<?php


namespace App\Providers;


use App\Models\Language;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Route;

use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;


class RouteServiceProvider extends ServiceProvider

{

    /**
     * This namespace is applied to your controller routes.
     *
     * In addition, it is set as the URL generator's root namespace.
     *
     * @var string
     */

    protected $namespace = 'App\Http\Controllers';


    /**
     * Define your route model bindings, pattern filters, etc.
     *
     * @return void
     */

    public function boot()

    {

        //


        parent::boot();

    }


    /**
     * Define the routes for the application.
     *
     * @return void
     */

    public function map()

    {

        $this->mapApiRoutes();


        $this->mapWebRoutes();


        //

    }


    /**
     * Define the "web" routes for the application.
     *
     * These routes all receive session state, CSRF protection, etc.
     *
     * @return void
     */

    protected function mapWebRoutes()
    {
        $segmentOne = request()->segment(1);
        $language_short_names = Language::pluck('language_short_name')->all();
        $default_language = Language::where('language_default', 1)->first();

        if (in_array($segmentOne, $language_short_names)) {
            \App::setLocale($segmentOne);
            Route::middleware('web')->namespace($this->namespace)->group(base_path('routes/web-'.$segmentOne.'.php'));
        }else {
            \App::setLocale($default_language->language_short_name);
            Route::middleware('web')->namespace($this->namespace)->group(base_path('routes/web.php'));
        }

    }


    /**
     * Define the "api" routes for the application.
     *
     * These routes are typically stateless.
     *
     * @return void
     */

    protected function mapApiRoutes()

    {

        Route::prefix('api')
            ->middleware('api')
            ->namespace($this->namespace)
            ->group(base_path('routes/api.php'));

    }

}

