<?php
namespace App\Providers;
use App\Models\ArticleDetail;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Carbon\Carbon;
class AppServiceProvider extends ServiceProvider
{
    public function boot()
    {
        date_default_timezone_set('Europe/Istanbul');
        Schema::defaultStringLength(191);
        create_captcha();


        Carbon::setLocale(session('langname'));

        Artisan::call('view:clear');

        date_default_timezone_set("Europe/Istanbul");
        /*$timed_articles = ArticleDetail::where('status', 0)->where('published_at', '!=', null)->get();
        foreach ($timed_articles as $timed_article) {
            if (strtotime($timed_article->published_at) < strtotime(date("Y-m-d H:i:s"))) {
                $set_visible = ArticleDetail::where('article_id', $timed_article->article_id)->update(['status' => 1]);
            }
        }*/

    }

    public function register()
    {
        require_once __DIR__ . '/../Helper.php';

        if ($this->app->environment() !== 'production') {
            $this->app->register(\Barryvdh\LaravelIdeHelper\IdeHelperServiceProvider::class);
        }
    }
}