<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VideoGalleryCategoriesDetail extends Model
{
    protected $table = 'video_gallery_categories_details';
    protected $primaryKey = 'gallery_details_id';
    protected $guarded = [];
    public $timestamps = false;

    public function videos()
    {
        return $this->hasMany('App\Models\VideoGalleriesDetail', 'gallery_id', 'gallery_id');
    }
    public static function getVideosCount($gallery_id)
    {
        return \App\Models\VideoGalleriesDetail::where('gallery_id', $gallery_id)->count();
    }

}
