<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VideoGalleriesDetail extends Model
{
    protected $table = 'video_galleries_details';
    protected $primaryKey = 'video_details_id';
    protected $guarded = [];
    public $timestamps = false;

    public function getFooterCategory($language_id, $gallery_id)
    {
        return VideoGalleryCategoriesDetail::where('language_id', $language_id)->where('gallery_id', $gallery_id)->first();
    }

    public function category()
    {
        return $this->hasOne('App\Models\VideoGalleryCategoriesDetail', 'gallery_id', 'gallery_id');
    }

    public function language() {
        return $this->hasOne('App\Models\Language', 'language_id', 'language_id');
    }

    public function comments($lang) {
        return Comment::where('video_id', $this->video_id)->where('language_id', $lang)->get();
    }

}
