<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use App\Notifications\ResetPassword as ResetPasswordNotification;

class User extends Authenticatable
{
    use Notifiable;
    use SoftDeletes;

    protected $guarded = [];

    protected $hidden = [
        'password', 'activation_code'
    ];

    public function detail(){
        return $this->hasOne('App\Models\UserDetail');
    }
    public function sendPasswordResetNotification($token)
    {
        // Your your own implementation.
        $this->notify(new ResetPasswordNotification($token));
    }

    public function roleUser()
    {
        return $this->hasOne('App\Models\RoleUser', 'user_id', 'id');
    }

    public function roles()
    {
        return $this->belongsToMany('App\Models\Role');
    }
    public function authorizeRoles($roles)
    {
        return true;
        /*if (is_array($roles))
        {
            return $this->hasAnyRole($roles) ||
                abort(403, '<div class="col-lg-6 col-12 offset-lg-3 text-center"><p><i style="color: #f8ce2f;" class="fas fa-exclamation-circle fa-7x"></i></p><h1 class="mb-3">Üzgünüm!</h1><div class="alert alert-warning" role="alert">Bu İşlemi Yapmak İçin Gerekli Yetkiye Sahip Değilsiniz.</div></div>');
        }
        return $this->hasRole($roles) ||
            abort(403, '<div class="col-lg-6 col-12 offset-lg-3 text-center"><p><i style="color: #f8ce2f;" class="fas fa-exclamation-circle fa-7x"></i></p><h1 class="mb-3">Üzgünüm!</h1><div class="alert alert-warning" role="alert">Bu İşlemi Yapmak İçin Gerekli Yetkiye Sahip Değilsiniz.</div></div>');*/
    }

    public function hasAnyRole($roles)
    {
        return null !== $this->roles()->whereIn('name', $roles)->first();
    }

    public function hasRole($role)
    {
        return null !== $this->roles()->where('name', $role)->first();
    }
}