<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Theme extends Model
{
    protected  $table = 'themes';
    protected  $primaryKey ='theme_id';
    protected  $guarded = [];

    public function themeDetails() {
        return $this->hasMany('App\Models\ThemeDetail', 'theme_id', 'theme_id');
    }

    public function getImage() {
        return $this->hasOne('App\Models\ThemeImage', 'theme_id', 'theme_id');
    }

    public function themeDetail($theme_id, $language_id) {
        return ThemeDetail::where('theme_id', $theme_id)->where('language_id', $language_id)->first();
    }

}
