<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    protected $table = 'products';
    protected $guarded = [];
    protected $primaryKey  = 'id';


    public static function ByCount($id)
    {
        return \App\Models\Product::where('id', $id)->count();
    }

    public function  productImages(){
        return $this->hasMany('App\Models\ProductImage','product_id','id');
    }

    public function categories(){
        return $this->belongsToMany(Category::class);
    }
}
