<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PhotoGalleryDetail extends Model
{
    protected $table = 'photo_gallery_details';
    public $timestamps = false;
    protected $primaryKey = 'photo_gallery_id';
    protected $guarded = [];

    public static function ByCount($gallery_id)
    {
        return \App\Models\PhotoGalleryDetail::where('photo_gallery_id', $gallery_id)->count();
    }

    public function photos($language_id)
    {
        return $this->hasMany('App\Models\PhotoDetail', 'photo_gallery_id', 'photo_gallery_id')->where('language_id', $language_id)->get();
    }

}
