<?php



namespace App\Models;



use Illuminate\Database\Eloquent\Model;



class PageDetail extends Model

{

    protected  $table = 'page_details';

    protected  $primaryKey ='page_details_id';

    protected  $guarded = [];



    public function page()

    {

        return $this->hasOne('App\Models\Page', 'page_id', 'page_id');

    }

    public function language() {
        return $this->hasOne('App\Models\Language', 'language_id', 'language_id');
    }

    public function getComments($lang_id)
    {
        return Comment::where('page_id', $this->page_id)->where('status', 1)->where('upcomment_id', '=', null)->where('language_id',$lang_id)->get();

    }

}

