<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MenuDetail extends Model
{
    protected $table = 'menu_details';
    protected $primaryKey = 'menu_detail_id';
    protected $guarded = ['menu_detail_id','created_at','updated_at'];

    public function menu()
    {
        return $this->belongsTo('App\Models\Menu', 'menu_id', 'menu_id');
    }

    public function language() {
        return $this->hasOne('App\Models\Language', 'language_id', 'language_id');
    }

}
