<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\MenuDetail;

class Menu extends Model
{
    protected $table = 'menus';
    protected $primaryKey = 'menu_id';
    protected $fillable = ['menu_name'];

    public function detail()
    {
        return $this->hasMany('App\Models\MenuDetail',
            'menu_id',
            'menu_id'
        );
    }

    public static function getMenus($menu_id, $parent = 0, $language_id){
        $menuler = MenuDetail::where('menu_id', $menu_id)->where('parent_id', $parent)->where('language_id',$language_id)->orderBy('parent_id')->orderBy('sira')->get();

        $rdata = '';
        foreach($menuler as $menu)
        {
            if ($menu->type == 'normal')
            {
                $sel2 = 'selected="selected"';
            } else {
                $sel2 = '';
            }
            if ($menu->type == 'mega')
            {
                $sel3 = 'selected="selected"';
            } else {
                $sel3 = '';
            }
            if (count(\App\Models\MenuDetail::where('parent_id', $menu->menu_detail_id)->where('language_id', $language_id)->get()) == 0 )
            {
                if ($menu->target == '_self')
                {
                    $sel0 = 'selected="selected"';
                } else {
                    $sel0 = '';
                }
                if ($menu->target == '_blank')
                {
                    $sel1 = 'selected="selected"';
                } else {
                    $sel1 = '';
                }
                $rdata .= '<li id="list_' . $menu->menu_detail_id . '"><div class="collapse-title">' . $menu->menu . '<span class="disclose"><i class="fas fa-chevron-down"></i></span></div><div class="collapse-content"><em class="ikinciem">Menü Adı : </em><input type="text" value="' . $menu->menu . '" name="menu_adi['.$menu->language->language_short_name.'][' . $menu->menu_detail_id . ']" class="nestedinput" /><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Menü Url</em> <input type="text" value="' . $menu->link . '" name="menu_url['.$menu->language->language_short_name.'][' . $menu->menu_detail_id . ']" class="nestedinput" /><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Özel Css</em> <input type="text" name="menu_css['.$menu->language->language_short_name.'][' . $menu->menu_detail_id . ']" class="nestedinput" value="' . $menu->css . '" /><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">İkon</em> <input type="text" name="menu_ikon['.$menu->language->language_short_name.'][' . $menu->menu_detail_id . ']" class="nestedinput" value="' . $menu->icon . '" /><span style="clear:both; float: left; width: 100%;"><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Resim</em> <input type="text" name="menu_resim['.$menu->language->language_short_name.'][' . $menu->menu_detail_id . ']" class="nestedinput" value="' . $menu->resim . '" /><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Konum</em><select name="target['.$menu->language->language_short_name.'][' . $menu->menu_detail_id . ']" class="nestedinput"><option value="_self" ' . $sel0 . '>Aynı Sayfada Açılsın</option><option value="_blank" ' . $sel1 . '>Farklı Sayfada Açılsın</option></select><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Menü Tipi</em><select name="menu_type['.$menu->language->language_short_name.'][' . $menu->menu_detail_id . ']" class="nestedinput"><option value="normal" selected="selected" ' . $sel2 . '>Normal Menü</option><option value="mega" ' . $sel3 . '>Mega Menü</option></select><button type="button" class="menusil" onclick="menuSil(' . $menu->menu_detail_id . ')"><i class="fa fa-trash" aria-hidden="true"></i></button></div>';
            } else {
                $rdata .= '<li id="list_' . $menu->menu_detail_id . '"><div class="collapse-title">' . $menu->menu . ' <span class="disclose"><i class="fas fa-chevron-down"></i></span></div><div class="collapse-content"><em class="ikinciem">Menü Adı</em><input type="text" value="' . $menu->menu . '" name="menu_adi['.$menu->language->language_short_name.'][' . $menu->menu_detail_id . ']" class="nestedinput" /><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Menü Url</em> <input type="text" value="' . $menu->link . '" name="menu_url['.$menu->language->language_short_name.'][' . $menu->menu_detail_id . ']" class="nestedinput" /><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Özel Css</em> <input type="text" name="menu_css['.$menu->language->language_short_name.'][' . $menu->menu_detail_id . ']" class="nestedinput" value="'.$menu->css.'" /><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">İkon</em> <input type="text" name="menu_ikon['.$menu->language->language_short_name.'][' . $menu->menu_detail_id . ']" class="nestedinput" value="' . $menu->icon . '" /><span style="clear:both; float: left; width: 100%;"><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Resim</em> <input type="text" name="menu_resim['.$menu->language->language_short_name.'][' . $menu->menu_detail_id . ']" class="nestedinput" value="' . $menu->resim . '" /><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Menü Tipi</em><select name="menu_type['.$menu->language->language_short_name.'][' . $menu->menu_detail_id . ']" class="nestedinput"><option value="normal" selected="selected" ' . $sel2 . '>Normal Menü</option><option value="mega" ' . $sel3 . '>Mega Menü</option></select><button type="button" class="menusil" onclick="menuSil(' . $menu->menu_detail_id . ')"><i class="fa fa-trash" aria-hidden="true"></i></button></div>';
                $rdata .= Menu::getSubMenus($menu_id, $menu->menu_detail_id, $language_id);
            }
        }
        return $rdata;
    }

    public static function getSubMenus($menu_id, $level = 0, $language_id)
    {
        $tree = MenuDetail::where('menu_id', $menu_id)->where('parent_id', $level)->where('language_id', $language_id)->orderBy('parent_id')->orderBy('sira')->get();
        $veri = '';
        foreach ($tree as $id => $item)
        {
            if (count(\App\Models\MenuDetail::where('parent_id', $item->menu_detail_id)->where('language_id', $language_id)->get()) == 0 )
            {
                if ($item->target == '_self') { $sel0 = 'selected="selected"'; } else { $sel0 = ''; }
                if ($item->target == '_blank') { $sel1 = 'selected="selected"'; } else { $sel1 = ''; }
                $veri .= '<ol>';
                $veri .= '<li id="list_' . $item->menu_detail_id . '"><div class="collapse-title">' . $item->menu . ' <span class="disclose"><i class="fas fa-chevron-down"></i></span></div><div class="collapse-content"> <em class="ikinciem">Menü Adı : </em> <input type="text" value="' . $item->menu . '" name="menu_adi[' . $item->menu_detail_id . ']" class="nestedinput" /><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Menü Url</em> <input type="text" value="' . $item->link . '" name="menu_url[' . $item->menu_detail_id . ']" class="nestedinput" /><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Özel Css</em> <input type="text" name="menu_css[' . $item->menu_detail_id . ']" class="nestedinput" value="' . $item->css . '" /><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">İkon</em> <input type="text" name="menu_ikon[' . $item->menu_detail_id . ']" class="nestedinput" value="' . $item->icon . '" /><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Konum</em><select name="target[' . $item->menu_detail_id . ']"><option value="_self" ' . $sel0 . '>Aynı Sayfada Açılsın</option><option value="_blank" ' . $sel1 . '>Farklı Sayfada Açılsın</option></select><button type="button" class="menusil" onclick="menuSil(' . $item->menu_detail_id . ')"><i class="fa fa-trash" aria-hidden="true"></i></button></div>';
                $veri .= '</ol>';

            } else {
                $veri .= '<ol>';
                $veri .= '<li id="list_' . $item->menu_detail_id . '"><div class="collapse-title">' . $item->menu . ' <span class="disclose"><i class="fas fa-chevron-down"></i></span></div><div class="collapse-content"> <em class="ikinciem">Menü Adı</em> <input type="text" value="' . $item->menu . '" name="menu_adi[' . $item->menu_detail_id . ']" class="nestedinput" /><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Menü Url</em> <input type="text" value="' . $item->link . '" name="menu_url[' . $item->menu_detail_id . ']" class="nestedinput" /><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">Özel Css</em> <input type="text" name="menu_css[' . $item->menu_detail_id . ']" class="nestedinput" value="'.$item->css.'" /><span style="clear:both; float: left; width: 100%;"></span><em class="ikinciem">İkon</em> <input type="text" name="menu_ikon[' . $item->menu_detail_id . ']" class="nestedinput" value="' . $item->icon . '" /><button type="button" class="menusil" onclick="menuSil(' . $item->menu_detail_id . ')"><i class="fa fa-trash" aria-hidden="true"></i></button></div>';
                $veri .= self::getSubMenus($menu_id, $item->menu_detail_id, $language_id);
                $veri .= '</ol>';
            }
        }
        unset($item);
        return $veri;
    }
//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// <!--Dwfault Menü-->
    public static function getFrontMenus($menu_id, $parent_id = 0, $language_id) {
        $menuler = \App\Models\MenuDetail::where('menu_id', $menu_id)->where('parent_id', $parent_id)->where('language_id', $language_id)->orderBy('sira')->get();
        $mdata = '';
        $i = 0;
        foreach($menuler as $menu) {
            if (count(\App\Models\MenuDetail::where('parent_id', $menu->menu_detail_id)->where('language_id', $language_id)->get()) == 0) {
                $mdata .= '<li ><a href="' . $menu->link . '" target="' . $menu->target . '" title="' . $menu->menu . '" class="link" >' . $menu->menu . '</a></li>';
            } else {
                if ($i == 0) {
                    $mdata .= '<li class="main-href">
                  <a class="link"  href="' . $menu->link . '" target="' . $menu->target . '" title="' . $menu->menu . '">' . $menu->menu . '</a>
                  <div class="hover-menu"><div class="hover-menu-content"><div class="hover-nav"><ul>';
                    $mdata .= self::getFrontSubMenus($menu_id, $menu->menu_detail_id, $language_id);
                    $mdata .= '</ul></div><div class="hover-image"></div></div></li>';
                }else {
                    $mdata .= '<li class="main-href">
                  <a class="link" href="' . $menu->link . '" target="' . $menu->target . '" title="' . $menu->menu . '">' . $menu->menu . '</a>
                  <div class="hover-nav"><ul>';
                    $mdata .= self::getFrontSubMenus($menu_id, $menu->menu_detail_id, $language_id);
                    $mdata .= '</ul></div></li>';
                }
                $i++;

            }
        }
        return $mdata;
    }

    public static function getFrontSubMenus($menu_id, $level = 0,$language_id)
    {
        $tree = \App\Models\MenuDetail::where('menu_id', $menu_id)->where('parent_id', $level)->where('language_id', $language_id)->orderBy('sira')->get();
        $veri = '';
        foreach ($tree as $id => $item) {
            $veri .= '<li><a href="' . $item->link . '" target="' . $item->target . '" title="' . $item->menu . '">' . $item->menu . '</a></li>';
        }
        return $veri;
    }

    public static function getMobilSubMenus($menu_id, $level,$language_id)
    {
        $tree = \App\Models\MenuDetail::where('menu_id', $menu_id)->where('parent_id', $level)->where('language_id', $language_id)->orderBy('sira')->get();
        $veri = '';
        foreach ($tree as $id => $item) {
            if (\App\Models\MenuDetail::where('parent_id', $item->menu_detail_id)->where('language_id', $language_id)->count() == 0) {
                $veri .= '<li class="' . $item->css . '">' . $item->icon . ' <a href="' . $item->link . '" title="' . $item->menu . '" target="' . $item->target . '">' . $item->menu . '</a></li>';
            } else {
                $veri .= '<li class="dropdown-nav"><a aria-expanded="false" href="'.$item->link.'">' . $item->menu . '</a><ul>';
                $veri .= self::getMobilSubMenus($menu_id, $item->menu_detail_id,$language_id);
                $veri .= '</ul></li>';
            }
        }
        return $veri;
    }

    public static function getTopMenus($menu_id) {
        $menuler = \App\Models\MenuDetail::where('menu_id', $menu_id)->orderBy('sira')->get();
        $mdata = '';
        foreach($menuler as $menu) {
            $mdata .= '<li><a href="' . $menu->link . '" target="' . $menu->target . '" title="' . $menu->menu . '">' . $menu->menu . '</a></li>';
        }
        return $mdata;
    }

    //Orjinal hali
    /*
    public static function getFooterMenus($menu_id, $parent_id = 0) {
        $menuler = \App\Models\MenuDetail::where('menu_id', $menu_id)->where('parent_id', $parent_id)->orderBy('sira')->get();
        $mdata = '';
        foreach($menuler as $menu) {
            if (\App\Models\MenuDetail::where('parent_id', $menu->menu_detail_id)->count() == 0) {
                $mdata .= '<div class="col-lg-3"><strong class="' . $menu->css . '"></strong>' . $menu->icon . ' <a href="' . $menu->link . '" title="' . $menu->menu . '" target="' . $menu->target . '">' . $menu->menu . '</a></li>';
            } else {
                $mdata .= '<div class="col-lg-3"><ul><li><strong class="footer-widget-title"><a href="#">' . $menu->menu . '</a></strong>';
                $mdata .= self::getFooterSubMenus($menu_id, $menu->menu_detail_id);
                $mdata .= '</li></ul></div>';
            }
        }
        return $mdata;
    }*/

    //Arata uyarlanmış hali
    public static function getFooterMenus($menu_id, $parent_id = 0)
    {
        $menuler = \App\Models\MenuDetail::where('menu_id', $menu_id)->where('parent_id', $parent_id)->orderBy('sira')->get();
        $mdata = '';
        $count = -1;
        foreach ($menuler as $menu) {
            $count++;
            if (\App\Models\MenuDetail::where('parent_id', $menu->menu_detail_id)->count() == 0) {
                if($count == 0){
                    $mdata .= '<div class="col-lg-8">
                                <div class="footer-title">
                                <p class="footer-widget-title" >' . $menu->menu . '</p>
                                <p style="text-align: justify">Samsun merkezli olarak faaliyet gösteren firmamız 1986 yılından itibaren siz değerli
                            müşterilerimizin ihtiyaçlarını sorunsuz olarak karşılamaktadır. P.V.C. kart imalatı amacıyla
                            kurulan firmamız daha sonra ürün yelpazesini genişleterek, bugün Plastik Kart sektöründe hak
                            ettiği yeri almıştır. </p>
                        <hr>
                        <p>İlkadım Sanayi Sitesi. Uzunlar Cad. No:8 Kirazlık/Tekkeköy</p>
                        <p><i class="fas fa-phone-square"></i> +90 (362) 445 0910 - 20</p>
                                </div>
                                </div>';
                }else{
                    $mdata .= '<div class="col-lg-2">
                                <strong class="' . $menu->css . '">
                                 </strong>' . $menu->icon . ' 
                                <a href="' . $menu->link . '" title="' . $menu->menu . '" target="' . $menu->target . '">' . $menu->menu . '
                                 </a>
                                </li>
                                </div>';
                }

            } else {
                $mdata .= '<div class="col-lg-2 col-6"><div class="footer-title"><p class="footer-widget-title">' . $menu->menu . '</p>';
                $mdata .= self::getFooterSubMenus($menu_id, $menu->menu_detail_id);
                $mdata .= '</div></div>';
            }
        }
        return $mdata;
    }

    //Arata uyarlanmış hali
    public static function getFooterSubMenus($menu_id, $level)
    {
        $tree = \App\Models\MenuDetail::where('menu_id', $menu_id)->where('parent_id', $level)->orderBy('sira')->get();
        $veri = '';

        foreach ($tree as $id => $item) {
            if (\App\Models\MenuDetail::where('parent_id', $item->menu_detail_id)->count() == 0) {
                $veri .='<ul><li><a href="'.$item->link.'">'.$item->menu.'</a></li></ul>';
            } else {
                $veri .= '<div class="col-lg-2"><ul><li><a href="#">' . $item->menu . ' </a>';
                $veri .= self::getFooterSubMenus($menu_id, $item->menu_detail_id);
                $veri .= '</li></ul>';
            }
        }
        return $veri;
    }

    //Orjinal hali
    /*
    public static function getFooterSubMenus($menu_id, $level)
    {
        $tree = \App\Models\MenuDetail::where('menu_id', $menu_id)->where('parent_id', $level)->orderBy('sira')->get();
        $veri = '';

        foreach ($tree as $id => $item) {
            if (\App\Models\MenuDetail::where('parent_id', $item->menu_detail_id)->count() == 0) {
                $veri .='<div class="' . $item->css . '">'. $item->icon . ' <a href="' . $item->link . '" title="' . $item->menu . '" target="' . $item->target . '">' . $item->menu . '</a>';
            } else {
                $veri .= '<div class="col-lg-3"><ul><li><a href="#">' . $item->menu . ' </a>';
                $veri .= self::getFooterSubMenus($menu_id, $item->menu_detail_id);
                $veri .= '</li></ul></div>';
            }
        }
        return $veri;
    }
    */
}
