<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MedicalStaff extends Model
{
    protected $table = 'medical_staffs';
    protected $primaryKey = 'medical_staff_id';
    protected $guarded = [];

    public function medicalStaffDetail() {
        return $this->hasMany('App\Models\MedicalStaffDetail', 'medical_staff_id', 'medical_staff_id');
    }

    public function getDetailWithLang($language_id, $medical_staff_id) {

        return MedicalStaffDetail::where('language_id', $language_id)->where('medical_staff_id', $medical_staff_id)->first();

    }

}
