<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class CategoryDetail extends Model
{
    protected $table = 'category_details';
    protected $primaryKey = 'category_details_id';
    protected $guarded = [];
    public $timestamps = false;

    public function categories() {
        return $this->hasMany('App\Models\Category', 'category_id', 'category_id');
    }

    public function articles(){
        return $this->hasMany('App\Models\ArticleDetail','category_id','category_id');
    }

    public function scopeLang($query, $value)
    {
        return $query->where('language_id', $value);
    }

    public function language(){
        return $this->hasOne('App\Models\Language', 'language_id', 'language_id');
    }


}
