<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    protected $table = 'categories';
    protected $primaryKey = 'category_id';
    protected $guarded = [];

    public function articles(){
        return $this->hasMany('App\Models\ArticleDetail','category_id','category_id');
    }

    public function products(){
        return $this->belongsToMany(Product::class);
    }
}
