<?php



namespace App\Models;



use Illuminate\Database\Eloquent\Model;



class BlogDetail extends Model

{

    protected $table = 'blog_details';

    protected $primaryKey = 'blog_details_id';

    protected $guarded = [];



    public function blog()

    {

        return $this->hasOne('App\Models\Blog', 'blog_id', 'blog_id');

    }

    public function getComments($lang_id)
    {

        return Comment::where('blog_id', $this->blog_id)->where('status', 1)->where('upcomment_id', '=', null)->where('language_id',$lang_id)->get();

    }

    public function rating($blog_id) {
        return Rating::selectRaw('avg(rating) as rating')->where('blog_id', $blog_id)->first();
    }

    public function ratingIp() {
        return $this->hasMany('App\Models\RatingIp', 'blog_id', 'blog_id');
    }

    public function language() {
        return $this->hasOne('App\Models\Language', 'language_id', 'language_id');
    }

    public function getCategory($language_id) {
        return CategoryDetail::where('language_id', $language_id)->first();
    }

}

