<?php



namespace App\Models;



use Illuminate\Database\Eloquent\Model;

use App\Models\Rating;
use App\Models\RatingIp;

class ArticleDetail extends Model

{

    protected $table = 'article_details';

    protected $primaryKey = 'article_details_id';

    protected $guarded = [];



    public function article()

    {

        return $this->hasOne('App\Models\Article', 'article_id', 'article_id');

    }


    public function getComments($lang_id)

    {

        return Comment::where('article_id', $this->article_id)->where('status', 1)->where('upcomment_id', '=', null)->where('language_id',$lang_id)->get();

    }



    public function category()

    {

        return $this->hasOne('App\Models\CategoryDetail', 'category_id', 'category_id');

    }

    public function rating($article_id) {
        return Rating::selectRaw('avg(rating) as rating')->where('article_id', $article_id)->first();
    }

    public function ratingIp() {
        return $this->hasMany('App\Models\RatingIp', 'article_id', 'article_id');
    }

    public function language() {
        return $this->hasOne('App\Models\Language', 'language_id', 'language_id');
    }

    public function getCategory($category_id, $language_id) {
        return CategoryDetail::where('category_id', $category_id)->where('language_id', $language_id)->first();
    }

    public function getSss($article_id) {
        return Sss::where('article_id', $article_id)->where('status', 1)->orderBy('like', 'desc')->get();
    }

    public function getAuthor() {
        return $this->hasOne('App\Models\MedicalStaff', 'medical_staff_id', 'author');
    }

}

