<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Article extends Model
{
    protected $table = 'articles';
    protected  $primaryKey = 'article_id';
    protected  $guarded = [];

    public function articleDetail()
    {
        return $this->hasOne('App\Models\ArticleDetail', 'article_id', 'article_id');
    }
    public function getComments()
    {
        return Comment::where('article_id', $this->article_id)->where('status', 1)->where('upcomment_id', '=', null)->get();
    }
    public function category()
    {
        return $this->hasOne('App\Models\Category', 'category_id', 'category_id');
    }
    public function ssses()
    {
        return $this->hasMany('App\Models\Sss', 'article_id', 'article_id');
    }
}
