<?php

namespace App\Http\Controllers;

use App\Models\StaticMetas;
use App\Models\VideoGalleriesDetail;

use App\Models\VideoGalleryCategory;

use App\Models\VideoGalleryCategoriesDetail;

use Illuminate\Http\Request;


class VideoController extends Controller

{

    public function index()
    {

        $lang = $this->lang;
        $langname = $this->langname;

        $canonical = config('app.url') . '/' . __('urls.video_gallery') . '/';
        $kategoriler = VideoGalleryCategoriesDetail::where('status', 1)->where('in_gallery', 1)->where('language_id', $lang)->get();

        $href_langs = [];

        $breadcrumb = [
            'baslik' => __('general.videos'),
            'links' => [
                0 => [
                    'text' => __('general.home'),
                    'url' => route('anasayfa')
                ],
                1 => [
                    'text' => __('general.videos'),
                    'url' => null
                ]
            ]
        ];

        $href_langs = [];
        $dir = '../resources/lang';
        $langs = array_diff(scandir($dir), array('..', '.'));
        $langs = array_values($langs);
        $hrefLang_languages = \App\Models\Language::all();

        foreach ($hrefLang_languages as $hrefLang_language) {
            if (in_array($hrefLang_language->language_short_name, $langs)) {
                \App::setLocale($hrefLang_language->language_short_name);
                $href_lang = $hrefLang_language->language_short_name;
                if ($hrefLang_language->language_short_name == "tr") {
                    $url = '/' . \Lang::get('urls.video_gallery');
                } else {
                    $url = '/' . $hrefLang_language->language_short_name . '/' . \Lang::get('urls.video_gallery');
                }
                $href_langs[] = [
                    'href_lang' => $href_lang,
                    'url' => url('/') . $url
                ];
            }
        }
        \App::setLocale($langname);

        $static_meta = StaticMetas::where('page_slug', 'video')->first();


        return view('themes.' . config('site_settings.themes_dir') . '.video-galleries.videos', compact('kategoriler', 'kategorim', 'breadcrumb', 'canonical', 'lang', 'langname', 'static_meta', 'href_langs'));
    }

    public function videoDetail($slug = null)
    {
        $lang = $this->lang;
        $langname = $this->langname;

        $video = VideoGalleriesDetail::whereSlug($slug)->where('status', 1)->where('in_gallery', 1)->where('language_id', $lang)->first();
        $other_videos = VideoGalleriesDetail::where('status', 1)->where('in_gallery', 1)->inRandomOrder()->limit(10)->get();

        $hreflang_videos = VideoGalleriesDetail::where('video_id', $video->video_id)->get();

        $href_langs = [];
        $dir    = '../resources/lang';
        $langs = array_diff(scandir($dir), array('..', '.'));
        $langs = array_values($langs);
        $i = 0;

        foreach (\App\Models\Language::all() as $hrefLang_language) {
            if (in_array($hrefLang_language->language_short_name, $langs)) {
                if(!empty($hreflang_videos[$i]->slug)) {
                    \App::setLocale($hrefLang_language->language_short_name);
                    $href_lang = $hrefLang_language->language_short_name;
                    if ($hrefLang_language->language_short_name == "tr") {
                        $url = '/' . \Lang::get('urls.video_gallery').'/'.$hreflang_videos[$i]->slug;
                    } else {
                        $url = '/' . $hrefLang_language->language_short_name . '/' . \Lang::get('urls.video_gallery').'/'.$hreflang_videos[$i]->slug;
                    }
                    $href_langs[] = [
                        'href_lang' => $href_lang,
                        'url' => url('/') . $url
                    ];
                    $i++;
                }
            }
        }

        return view('themes.' . config('site_settings.themes_dir') . '.video-galleries.video', compact('video', 'canonical', 'lang', 'langname', 'href_langs', 'other_videos'));

    }

}