<?php

namespace App\Http\Controllers;

use App\Models\ArticleDetail;
use App\Models\BlogDetail;
use App\Models\CategoryDetail;
use App\Models\Language;
use App\Models\OurWork;
use App\Models\Page;
use App\Models\PageDetail;
use App\Models\Product;
use App\Models\ProductDetail;
use App\Models\ProductImage;
use Illuminate\Http\Request;
use Spatie\ArrayToXml\ArrayToXml;
use Carbon\Carbon;
use Illuminate\Support\Facades\URL;

class SitemapController extends Controller
{

     public function sitemaps()
    {
        return $this->all();
        /*
        switch ($type) {
            case "all":
                return $this->all();
                break;
            case "images":
                return $this->create($this->images());
                break;
            case "pages":
                return $this->create($this->pages());
                break;
            case "blogs":
                return $this->create($this->blogs());
                break;
            case "articles":
                return $this->create($this->articles());
                break;
            default:
                return $this->all();
                break;
        }*/
    }



    public function all()
    {

        $sitemaps['url'][] = $this->articles();
        $sitemaps['url'][] = $this->blogs();
        $sitemaps['url'][] = $this->pages();
        $sitemaps['url'][] = $this->images();
        $sitemaps['url'][] = $this->products();
        $sitemaps['url'][] = $this->corporate();
        $sitemaps['url'][] = $this->dealer();
        $sitemaps['url'][] = $this->referance();
        return $this->create($sitemaps);

    }

    public function images()
    {

        $articles = ArticleDetail::join('languages', 'languages.language_id', '=', 'article_details.language_id')->where('status', 1)->get();
        $blogs = BlogDetail::join('languages', 'languages.language_id', '=', 'blog_details.language_id')->where('status', 1)->get();

        $products = Product::join('product_descriptions','products.id','=','product_descriptions.product_id')->
        where('products.status',1)->
        select('products.alt_and_title','products.image','product_descriptions.slug','products.id')->get();

        $sitemap = [];

        /*foreach ($articles as $article) {

            $priority = 0.5;
            $url = $article->language_short_name == "tr" ? null : $article->language_short_name;
            $url .= '/' . $article->getCategory($article->category_id, $article->language_id)->slug . '/' . $article->slug;

            $sitemap['url'][] = [
                'loc' => url()->to($url),
                'image' => [
                    'loc' => URL::to($article->image),
                    'title' => $article->alt_and_title
                ],
                'changefreq' => "daily",
                'priority' => $priority
            ];
        }*/

        foreach($products as $product){
            $priority = 0.5;

            $url = '/'. trans('urls.product_url'). '/'.$product->slug;

            $images = ProductImage::where('product_id',$product->id)->get();

            $sitemap['url'][] = [
                'loc' => url()->to($url),
                'image:image' => [
                    'image:loc' => URL::to($product->image),
                    'image:title' => $product->alt_and_title
                ],
                'changefreq' => "daily",
                'priority' => $priority
            ];

        }


        foreach ($blogs as $blog) {

            $priority = 0.5;

            $url = $blog->language_short_name == "tr" ? null : $blog->language_short_name;
            $url .= '/'.trans('urls.blog_url').'/'.$blog->slug;

            $sitemap['url'][] = [
                'loc' => url()->to($url),
                'image:image' => [
                    'image:loc' => URL::to($blog->image),
                    'image:title' => $blog->alt_and_title
                ],
                'changefreq' => "daily",
                'priority' => $priority
            ];

        }

        return $sitemap;

    }

    public function pages()
    {

        $pages = PageDetail::where('status', 1)->get();
        $languages = Language::all();

        $sitemap = [];

        foreach ($pages as $page) {

            \App::setLocale($page->language->language_short_name);
            if ($page->language->language_short_name == "tr") {
                $page_slug = url('/') . '/' . __('urls.page_url') . '/' . $page->slug;
            } else {
                $page_slug = url('/') . '/' . $page->language->language_short_name . '/' . __('urls.page_url') . '/' . $page->slug;
            }

            $sitemap['url'][] = [
                'loc' => $page_slug,
                'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                'changefreq' => "monthly",
                'priority' => 0.5
            ];

        }

        foreach ($languages as $language) {

            if ($language->language_short_name != "tr") {
                $customSegment = '/' . $language->language_short_name . '/';
            } else {
                $customSegment = "/";
            }

            \App::setLocale($language->language_short_name);
            $sitemap['url'][] = [
                'loc' => url('/') . $customSegment,
                'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                'changefreq' => "daily",
                'priority' => 1
            ];

            $sitemap['url'][] = [
                'loc' => url('/') . $customSegment . __('urls.contact_url'),
                'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                'changefreq' => "daily",
                'priority' => 0.5
            ];

            $sitemap['url'][] = [
                'loc' => url('/') . $customSegment . __('urls.blog_url'),
                'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                'changefreq' => "daily",
                'priority' => 0.5
            ];

            $sitemap['url'][] = [
                'loc' => url('/') . $customSegment . __('urls.video_gallery'),
                'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                'changefreq' => "daily",
                'priority' => 0.5
            ];

        }

        return $sitemap;

    }

    public function blogs()
    {

        $blogs = BlogDetail::where('status', 1)->get();

        $sitemap = [];

        foreach ($blogs as $blog) {

            \App::setLocale($blog->language->language_short_name);
            if ($blog->language->language_short_name == "tr") {
                $blog_slug = url('/') . '/' . __('urls.blog_url') . '/' . $blog->slug;
            } else {
                $blog_slug = url('/') . '/' . $blog->language->language_short_name . '/' . __('urls.blog_url') . '/' . $blog->slug;
            }

            $sitemap['url'][] = [
                'loc' => $blog_slug,
                'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                'changefreq' => "daily",
                'priority' => 0.8
            ];

        }

        return $sitemap;

    }

    public function articles()
    {

        $articles = ArticleDetail::where('status', 1)->get();

        $sitemap = [];

        foreach ($articles as $article) {

            $priority = 0.5;

            if ($article->language->language_short_name == "tr") {
                $article_slug = url('/') . '/' . $article->category->slug . '/' . $article->slug;

            } else {
                $article_slug = url('/') . '/' . $article->language->language_short_name . '/' . $article->getCategory($article->category_id, $article->language->language_id)->slug . '/' . $article->slug;
            }

            if ($article->category->slug == "sac-ekimi" || $article->getCategory($article->category_id, $article->language->language_id)->slug == "haartransplantation") {
                $priority = 0.75;
            }

            $sitemap['url'][] = [
                'loc' => $article_slug,
                'lastmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s.uP'),
                'changefreq' => "daily",
                'priority' => $priority
            ];
        }

        return $sitemap;

    }

    public function products(){

        $products = Product::join('product_descriptions','products.id','=','product_descriptions.product_id')->where('products.status',1)->get();

        return $this->schemaStimeMap($products);
    }

    public function corporate(){
        $sitemap = [];

            $corporate_slug = url('/').'/kurumsal';

            $sitemap['url'][] = [
                'loc' => $corporate_slug,
                'lasmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s:uP'),
                'changefreq' => "daily",
                'priority' => 0.8
            ];


        return $sitemap;
    }

    public  function dealer(){
         $sitemap = [];

         $dealer = url('/').'/bayiler';
         $sitemap['url'][] = [
             'loc' => $dealer,
             'lasmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s:uP'),
             'changefreq' => 'daily',
             'priority' => 0.8
         ];

         return $sitemap;

    }

    public function referance(){
         $sitemap = [];

         $referance = url('/').'/referanslar';
         $sitemap['url'][] = [
            'loc' => $referance,
            'lasmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s:uP'),
            'changefreq' => 'daily',
            'priority' => 0.8
         ];

         return $sitemap;
    }

    public  function schemaStimeMap($data){
        $sitemap = [];
         foreach ($data as $val){
             $val_slug = url('/').'/'.__('urls.product_url') .'/'.$val->slug;

             $sitemap['url'][] = [
                 'loc' => $val_slug,
                 'lasmod' => Carbon::now('Europe/Istanbul')->format('Y-m-d\TH:i:s:uP'),
                 'changefreq' => "daily",
                 'priority' => 0.8
             ];
         }
         return $sitemap;
    }

    public function create($sitemap)
    {


        $map_attribute = [
            'rootElementName' => 'sitemapindex',
            '_attributes' => [
                'xmlns' => 'http://www.sitemaps.org/schemas/sitemap/0.9',
                'xmlns:image' => "http://www.google.com/schemas/sitemap-image/1.1"
            ]
        ];

        $result = ArrayToXml::convert($sitemap, $map_attribute, true, 'UTF-8');

        return response($result, 200)->header('Content-Type', 'text/xml');

    }

}
