<?php

namespace App\Http\Controllers;

use App\Models\Article;
use App\Models\ArticleDetail;
use App\Models\Blog;
use App\Models\BlogDetail;
use App\Models\VideoGalleriesDetail;
use App\Models\VideoGallery;
use Illuminate\Http\Request;

class SearchController extends Controller
{
    public function index()
    {
        $lang     = $this->lang;
        $langname = $this->langname;
        $keyword = request('keyword');
        $articles_result = ArticleDetail::where('article_title', 'like', '%' . $keyword . '%')->where('language_id',$lang)
            ->where('article_content', 'like', '%' . $keyword . '%')
            ->get();
        $blog_result = BlogDetail::where('blog_title', 'like', '%' . $keyword . '%')
            ->where('blog_content', 'like', '%' . $keyword . '%')->where('language_id',$lang)
            ->get();
        $video_result = VideoGalleriesDetail::where('video_name', 'like', '%' . $keyword . '%')->where('language_id',$lang)
            ->where('video_description', 'like', '%' . $keyword . '%')
            ->get();
        $breadcrumb = [
            'baslik' => trans('general.search_result'),
            'links' => [
                0 => [
                    'text' => trans('general.home'),
                    'url' => route('anasayfa')
                ],
                1 => [
                    'text' => trans('general.search_result'),
                    'url' => null
                ]
            ]
        ];

        $total_result = (count($articles_result)+count($blog_result)+count($video_result));
        return view('themes.' . config('site_settings.themes_dir') . '.searchresult', compact('articles_result', 'blog_result', 'video_result', 'total_result', 'keyword', 'breadcrumb','lang','langname'));
    }
}
