<?php
namespace App\Http\Controllers;
use App\Models\PhotoDetail;
use App\Models\PhotoGallery;
use App\Models\PhotoGalleryDetail;
use Illuminate\Http\Request;
class PhotoController extends Controller
{
    public function index()
    {
        $lang = $this->lang;
        $langname = $this->langname;
        $breadcrumb = [
            'baslik' => trans('general.photo-galleries'),
            'links' => [
                0 => [
                    'text' => trans('general.home'),
                    'url' => route('anasayfa')
                ],
                1 => [
                    'text' => trans('general.photo-galleries'),
                    'url' => route('photo-galeri')
                ]
            ]
        ];

        $photoGalleries = PhotoGalleryDetail::where('status', 1)->where('in_gallery', 1)->where('language_id', $lang)->get();

        return view('themes.' . config('site_settings.themes_dir') . '.photo-galleries.photo_gallery', compact('photoGalleries',  'breadcrumb', 'lang', 'langname'));
    }

    public function gallery($slug)
    {
        $lang = $this->lang;
        $langname = $this->langname;
        $photoGallery =PhotoGalleryDetail::where('status', 1)->whereSlug($slug)->where('in_gallery', 1)->where('language_id', $lang)->firstorFail();
        $photos = PhotoDetail::where('photo_gallery_id',$photoGallery->photo_gallery_id)->where('language_id',$lang)->where('status',1)->where('in_gallery',1)->orderBy('rank')->paginate(10);
        $breadcrumb = [
            'baslik' => $photoGallery->gallery_name,
            'links' => [
                0 => [
                    'text' => trans('general.home'),
                    'url' => route('anasayfa')
                ],
                1 => [
                    'text' => trans('general.photo-galleries'),
                    'url' => route('photo-galeri')
                ],
                2 => [
                    'text' => $photoGallery->gallery_name,
                    'url' => route('photo-galeri.detail',$photoGallery->slug)
                ]
            ]
        ];

        return view('themes.' . config('site_settings.themes_dir') . '.photo-galleries.photo', compact('photoGallery',  'breadcrumb', 'lang', 'langname','photos'));
    }

}