<?php

namespace App\Http\Controllers;

use App\Http\Controllers\SanalPos\EstPos;
use App\Models\Payment;
use Illuminate\Http\Request;

class PaymentController extends Controller
{


    public function index()
    {

        return view('themes.' . config('site_settings.themes_dir') . '.payment.payment');
    }

    public function paymentStart(Request $request)
    {


        $lang = $this->langname;

        $current = 949;
        $validatedData = $request->validate([
            'name' => 'required|max:75',
            'phone' => 'required|max:30',
            'current' => 'required',
            'amount' => 'required|numeric|min:50',
            'payment_note' => 'nullable|max:1000',
        ]);
        if ($request->current == "tl") {
            $current = 949;

        } elseif ($request->current == "dolar") {
            $current = 840;

        } elseif ($request->current == "euro") {
            $current = 978;

        } else {
            return redirect()->back()->with(['message_variable' => 'error', 'message' => __('payment.invalid_currency')]);
        }

        $amount = $request->amount;
        $payment = Payment::create([
            'name' => $request->name,
            'phone' => $request->phone,
            'note' => $request->payment_note,
            'amount' => $amount,
            'currency' => $current,
            'status' => 0,
        ]);
        $payment_id = $payment->payment_id;
        session()->put('payment_id', $payment_id);

        return view('themes.' . config('site_settings.themes_dir') . '.payment.pay', compact('current', 'amount', 'payment_id'));

    }

    public function paymentResult($action = null)
    {
        $estPay = new EstPos;

        if ($action == null) {
            if (session()->get('payment_id') == request('payment_id')) {
                session()->forget('payment_id');
                $cart_data = \request()->all();
                if (request()->has('amount')) {
                    $price = request('amount');
                } else {
                    //return
                }
                if (request()->has('current')) {
                    $currency = request('current');
                } else {
                    //return
                }
                $lang = $this->langname;

                $orders_no = "fbm" . time();
                $cc_month = substr($cart_data['cc_expiry'], 0, 2);
                $cc_year = substr($cart_data['cc_expiry'], -2, 2);
                $bank['cc_owner'] = $cart_data['cc_name'];
                $bank['cc_number'] = $cart_data['cc_number'];
                $bank['cc_cvv2'] = $cart_data['cc_cvc'];
                $bank['cc_expire_date_month'] = $cc_month;
                $bank['cc_expire_date_year'] = $cc_year;
                $webpos_bank['customer_ip'] = request()->ip();
                $webpos_bank['instalment'] = 0;//taksit
                $webpos_bank['currency'] = $currency;// parabirimi kodu
                $webpos_bank['success_url'] = route('payment-result', 'success'); //bank will return here if payment successfully finishes
                $webpos_bank['fail_url'] = route('payment-result', 'error'); //bank will return here if payment fails;
                $webpos_bank['order_id'] = $orders_no;
                $webpos_bank['total'] = $price;
                $webpos_bank['mode'] = "live";
                $webpos_bank['lang'] = $lang;
                $webpos_bank['order_info'] = "";
                $webpos_bank['products'] = "";

                $payment = Payment::find(request('payment_id'));
                $payment->order_id = $orders_no;
                $payment->currency = $webpos_bank['currency'];
                $payment->save();
                $webpos_bank = array_merge($bank, $webpos_bank);


                $method_response = $estPay->methodResponse($webpos_bank);
            } else {
                return redirect()->route('payment')->with(['message_variable' => 'error', 'message' => __('payment.wrong_transaction')]);
            }


        } else {

            //Sonuç Parametresi
            if ($action == "success") {
                $bank_response = request()->all();
                $webpos_bank = [];//Ekstra değer göndermek için
                //Para aktarımını başlatıyoruz
                $method_response = $estPay->bankResponse($bank_response, $webpos_bank);
                $orders_no = $bank_response["oid"];

                if (isset($bank_response["taksit"]) and !empty($bank_response["taksit"])) {
                    $instalment = $bank_response["taksit"];
                    $instalment = ($instalment == "") ? 0 : $instalment;
                } else {
                    $instalment = 0;
                }
                if ($method_response['result'] == 1) {
                    $message = $method_response['message'];
                    $price = $bank_response["amount"];//Çekilen tutar- Kontrol için kullanılabilird
                    $currency = $bank_response["currency"];//Çekilen tutar- Kontrol için kullanılabilird
                    //Çekilen İle Toplam Tutar Kontrolü

                    $payment = Payment::where('order_id', $bank_response['ReturnOid'])->first();
                    if (!empty($payment) && $price == $payment->amount && $currency == $payment->currency) {
                        $payment->transaction_id = @$bank_response['TransId'];
                        $payment->bank = "Qnb Finans Bank";
                        $payment->status = 1;
                        $payment->ccm_number = $bank_response['maskedCreditCard'];
                        $payment->bank_response = json_decode($bank_response['Response']);
                        $payment->save();
                        $result = "success";
                        $message = __('payment.success_message') . "<br><strong>" . __('payment.order_number') . " </strong>: " . $payment->order_id . "<br>";
                        return view('themes.' . config('site_settings.themes_dir') . '.payment.result', compact('result', 'message'));
                    } else {
                        $bank_response = request()->all();
                        $webpos_bank = [];//Ekstra değer göndermek için
                        $method_response = $estPay->bankResponse($bank_response, $webpos_bank);
                        $payment = Payment::where('order_id', $bank_response['ReturnOid'])->first();
                        $payment->transaction_id = $bank_response['TRANID'];
                        $payment->bank = "Qnb Finans Bank";
                        $payment->status = 2;
                        $payment->ccm_number = $bank_response['maskedCreditCard'];
                        $payment->bank_response = json_decode($method_response['message']);
                        $payment->save();
                        $result = "error";
                        $message = __('payment.error_message') . "<br>" . @$method_response['message'];
                        return view('themes.' . config('site_settings.themes_dir') . '.payment.result', compact('result', 'message'));

                    }
                } else {
                    $bank_response = request()->all();
                    $webpos_bank = [];//Ekstra değer göndermek için
                    $method_response = $estPay->bankResponse($bank_response, $webpos_bank);
                    $payment = Payment::where('order_id', $bank_response['ReturnOid'])->first();
                    $payment->transaction_id = $bank_response['TRANID'];
                    $payment->bank = "Qnb Finans Bank";
                    $payment->status = 2;
                    $payment->ccm_number = $bank_response['maskedCreditCard'];
                    $payment->bank_response = json_decode($method_response['message']);
                    $payment->save();
                    $result = "error";
                    $message = __('payment.error_message') . "<br>" . @$method_response['message'];
                    return view('themes.' . config('site_settings.themes_dir') . '.payment.result', compact('result', 'message'));

                }
            } else {
                $bank_response = request()->all();
                $webpos_bank = [];//Ekstra değer göndermek için
                $method_response = $estPay->bankResponse($bank_response, $webpos_bank);

                $payment = Payment::where('order_id', $bank_response['ReturnOid'])->first();
                $payment->bank = "Qnb Finans Bank";
                $payment->status = 2;
                $payment->bank_response = json_decode($method_response['message']);
                $payment->save();
                $result = "error";
                $message = __('payment.error_message') . "<br>" . @$method_response['message'];
                return view('themes.' . config('site_settings.themes_dir') . '.payment.result', compact('result', 'message'));
            }
        }

    }


}
