<?php


namespace App\Http\Controllers;


use App\Models\Page;

use App\Models\PageDetail;

use Illuminate\Http\Request;


class PageController extends Controller

{

    public function index($slug)

    {

        $lang = $this->lang;

        $langname = $this->langname;

        $page = PageDetail::whereSlug($slug)->where('language_id', $lang)->firstOrFail();

        $pages = PageDetail::where('language_id', $lang)->get();

        $hrefLang_pages = PageDetail::where('page_id', $page->page_id)->get();

        $breadcrumb = [

            'baslik' => $page->page_title,

            'links' => [

                0 => [

                    'text' => trans('general.home'),

                    'url' => route('anasayfa')

                ],

                1 => [

                    'text' => $page->page_title,

                    'url' => route('page', $page->slug)

                ]

            ]

        ];

        $canonical = route('page', $page->slug);

        $href_langs = [];
        $dir = '../resources/lang';
        $langs = array_diff(scandir($dir), array('..', '.'));
        $langs = array_values($langs);
        $hrefLang_languages = \App\Models\Language::all();
        $i = 0;

        foreach ($hrefLang_languages as $hrefLang_language) {
            if (in_array($hrefLang_language->language_short_name, $langs)) {
                if (!empty($hrefLang_pages[$i]->slug)) {
                    \App::setLocale($hrefLang_language->language_short_name);
                    $href_lang = $hrefLang_language->language_short_name;
                    if ($hrefLang_language->language_short_name == "tr") {
                        $url = '/' . \Lang::get('urls.page_url') . '/' . $hrefLang_pages[$i]->slug;
                    } else {
                        $url = '/' . $hrefLang_language->language_short_name . '/' . \Lang::get('urls.page_url') . '/' . $hrefLang_pages[$i]->slug;
                    }
                    $href_langs[] = [
                        'href_lang' => $href_lang,
                        'url' => url('/') . $url
                    ];
                    $i++;
                }
            }
        }
        \App::setLocale($langname);

        if (view()->exists('themes.' . config('site_settings.themes_dir') . '.templates.' . $page->page->template . '.page')) {
            return view('themes.' . config('site_settings.themes_dir') . '.templates.' . $page->page->template . '.page', compact('page', 'breadcrumb', 'hrefLang_pages', 'canonical', 'lang', 'langname', 'pages', 'href_langs'));
        } else {
            return view('founder::frontend.templates.' . $page->page->template . 'content', compact('page', 'breadcrumb', 'hrefLang_pages', 'canonical', 'lang', 'langname', 'pages', 'href_langs'));
        }


    }

    public function amp($slug){

        $lang = $this->lang;
        $langname = $this->langname;

        $page = PageDetail::whereSlug($slug)->where('status', 1)->firstOrFail();

        return view('themes.' . config('site_settings.themes_dir') . '.amp.pagecontent', compact('page', 'lang', 'langname'));

    }

}