<?php

namespace App\Http\Controllers;

use App\Models\OurWork;
use App\Models\OurWorkDetail;
use App\Models\StaticMetas;
use Illuminate\Http\Request;

class OurWorksController extends Controller
{
    public function index() {

        $lang = $this->lang;
        $langname = $this->langname;

        $works = OurWork::where('status', 1)->paginate(10);
        $static_metas = StaticMetas::where('page_slug', 'works')->where('language_id', $lang)->first();
        $breadcrumb = [
            'baslik' => __('works.works'),
            'links' => [
                0 => [
                    'text' => __('general.home'),
                    'url' => route('anasayfa')
                ],
                1 => [
                    'text' => __('works.works'),
                    'url' => route('works')
                ],
            ]

        ];
        return view('themes.'.config('site_settings.themes_dir').'.works.works', compact('static_metas', 'lang', 'breadcrumb', 'works'));

    }

    public function work($slug) {

        $lang = $this->lang;
        $langname = $this->langname;

        $work = OurWorkDetail::whereSlug($slug)->where('language_id', $lang)->first();
        $works = OurWork::where('status', 1)->orderByDesc('work_id')->limit(10)->get();
        $hrefLang_works = OurWorkDetail::where('work_id', $work->work_id)->get();

        $breadcrumb = [
            'baslik' =>  $work->work_title,
            'links' => [
                0 => [
                    'text' => __('general.home'),
                    'url' => route('anasayfa')
                ],
                1 => [
                    'text' => __('works.works'),
                    'url' => route('works')
                ],
                [
                    'text' => $work->work_title,
                    'url' => route('work', $work->slug)
                ]

            ]

        ];

        $work->work_content = $this->tocControl($work->work_content);

        return view('themes.' . config('site_settings.themes_dir') . '.works.work', compact('work', 'breadcrumb', 'hrefLang_works', 'lang', 'langname', 'works'));

    }

    protected static function tocControl($content)

    {

        if (strstr($content, "[toc]")) {

            preg_match_all('@<h2.*?>(.*?)<\/h2>@si', $content, $toclist);

            $toc = '<ul class="grilistele"><h2>İçindekiler</h2>';

            $i = 0;

            foreach ($toclist[0] as $tocl) {

                $mtocl = str_replace('<h2', '<h2 id="' . str_slug(strip_tags($tocl)) . '-' . $i . '"', $tocl);

                $content = str_replace($tocl, $mtocl, $content);

                $toc .= '<li><a href="#' . str_slug(strip_tags($tocl)) . '-' . $i . '">';

                $toc .= strip_tags($tocl);

                $toc .= '</a></li>';

                $i++;

            }

            $toc .= '</ul>';

        } else {

            $toc = '';

        }

        $content = str_replace('[toc]', $toc, $content);

        return $content;

    }

}
