<?php

namespace App\Http\Controllers;

use App\Models\MedicalStaff;
use App\Models\MedicalStaffDetail;
use App\Models\StaticMetas;
use Illuminate\Http\Request;

class MedicalStaffController extends Controller
{

    public function index()
    {
        $lang = $this->lang;
        $langname = $this->langname;

        $kadromuz = MedicalStaff::where('type', 'doctor')->get();
        $breadcrumb = [
            'baslik' => __('footer.ourdoctors'),
            'links' => [
                0 => [
                    'text' => __('public.homepage'),
                    'url' => route('anasayfa')
                ],
                1 => [
                    'text' => __('footer.ourdoctors'),
                    'url' => null
                ]
            ]
        ];

        $static_meta = StaticMetas::where('page_slug', 'doctors')->first();

        $href_langs = [];
        $dir = '../resources/lang';
        $langs = array_diff(scandir($dir), array('..', '.'));
        $langs = array_values($langs);
        $hrefLang_languages = \App\Models\Language::all();

        foreach ($hrefLang_languages as $hrefLang_language) {
            if (in_array($hrefLang_language->language_short_name, $langs)) {
                \App::setLocale($hrefLang_language->language_short_name);
                $href_lang = $hrefLang_language->language_short_name;
                if ($hrefLang_language->language_short_name == "tr") {
                    $url = '/' . \Lang::get('urls.staff_team');
                } else {
                    $url = '/' . $hrefLang_language->language_short_name . '/' . \Lang::get('urls.doctor_team');
                }
                $href_langs[] = [
                    'href_lang' => $href_lang,
                    'url' => url('/') . $url
                ];
            }
        }
        \App::setLocale($this->langname);

        return view('themes.' . config('site_settings.themes_dir') . '.kadromuz', compact('kadromuz', 'breadcrumb', 'static_meta', 'lang', 'langname', 'href_langs'));
    }

    public function personel()
    {

        $lang = $this->lang;
        $langname = $this->langname;

        $kadromuz = MedicalStaff::where('type', 'other')->get();
        $breadcrumb = [
            'baslik' =>  __('footer.ourstaff'),
            'links' => [
                0 => [
                    'text' => __('public.homepage'),
                    'url' => route('anasayfa')
                ],
                1 => [
                    'text' => __('footer.ourstaff'),
                    'url' => null
                ]
            ]
        ];

        $static_meta = StaticMetas::where('page_slug', 'staff')->first();

        $href_langs = [];
        $dir = '../resources/lang';
        $langs = array_diff(scandir($dir), array('..', '.'));
        $langs = array_values($langs);
        $hrefLang_languages = \App\Models\Language::all();

        foreach ($hrefLang_languages as $hrefLang_language) {
            if (in_array($hrefLang_language->language_short_name, $langs)) {
                \App::setLocale($hrefLang_language->language_short_name);
                $href_lang = $hrefLang_language->language_short_name;
                if ($hrefLang_language->language_short_name == "tr") {
                    $url = '/' . \Lang::get('urls.staff_team');
                } else {
                    $url = '/' . $hrefLang_language->language_short_name . '/' . \Lang::get('urls.staff_team');
                }
                $href_langs[] = [
                    'href_lang' => $href_lang,
                    'url' => url('/') . $url
                ];
            }
        }
        \App::setLocale($this->langname);

        return view('themes.' . config('site_settings.themes_dir') . '.kadromuz', compact('kadromuz', 'breadcrumb', 'static_meta', 'lang', 'langname','href_langs'));
    }

}
