<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\StaticMetas;

class IletisimController extends Controller
{

    public function index()
    {

        $lang = $this->lang;
        $langname = $this->langname;
        $breadcrumb = [
            'baslik' => trans('general.contact'),
            'links' => [
                0 => [
                    'text' => trans('general.home'),
                    'url' => route('anasayfa')
                ],
                1 => [
                    'text' => trans('general.contact'),
                    'url' => route('iletisim')
                ]
            ]
        ];

        $href_langs = [];
        $dir = '../resources/lang';
        $langs = array_diff(scandir($dir), array('..', '.'));
        $langs = array_values($langs);
        $hrefLang_languages = \App\Models\Language::all();

        foreach ($hrefLang_languages as $hrefLang_language) {
            if (in_array($hrefLang_language->language_short_name, $langs)) {
                \App::setLocale($hrefLang_language->language_short_name);
                $href_lang = $hrefLang_language->language_short_name;
                if ($hrefLang_language->language_short_name == "tr") {
                    $url = '/' . \Lang::get('urls.contact_url');
                } else {
                    $url = '/' . $hrefLang_language->language_short_name . '/' . \Lang::get('urls.contact_url');
                }
                $href_langs[] = [
                    'href_lang' => $href_lang,
                    'url' => url('/') . $url
                ];
            }
        }
        \App::setLocale($langname);
        $static_meta = StaticMetas::where('page_slug', 'iletisim')->first();
        return view('themes.' . config('site_settings.themes_dir') . '.iletisim', compact('breadcrumb', 'lang', 'static_meta', 'langname', 'href_langs'));

    }

}

