<?php

namespace App\Http\Controllers;

use App\Models\AppointmentSubjectDetail;
use App\Models\Article;
use App\Models\ArticleDetail;
use App\Models\CategoryDetail;
use App\Models\Slider;
use App\Models\SliderDetail;
use App\Models\StaticMetas;
use App\Models\Theme;
use App\Models\VideoGallery;
use App\Models\VideoGalleryCategoriesDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class HomeController extends Controller
{
    public function index()
    {
        $lang = $this->lang;
        $langname = $this->langname;

        $appointmentSubjects = AppointmentSubjectDetail::where('status',1)->where('language_id',$lang)->get();
        $sliders = SliderDetail::where('slider_status', 1)->where('language_id',$lang)->orderBy('rank')->get();
        $static_meta = StaticMetas::where('page_slug', 'home')->first();
        $articles = ArticleDetail::where('status', 1)->where('language_id', $lang)->get();
        $rows = Theme::join('theme_details', 'theme_details.theme_id', '=', 'themes.theme_id')->where('themes.row', 'SB')->where('theme_details.language_id', $this->lang)->get();
        $video_galleries = VideoGalleryCategoriesDetail::where('language_id', $lang)->get();

        return view('themes.' . config('site_settings.themes_dir') . '.anasayfa', compact('sliders', 'articles','lang','langname','appointmentSubjects', 'static_meta', 'rows', 'video_galleries'));

    }
}
