<?php
namespace App\Http\Controllers;
use App\Models\Language;
use App\Models\User;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Support\Facades\App;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    public $lang;
    public $langname;

    public function __construct() {

        $segmentOne = request()->segment(1);
        $defaultLanguage = Language::where('language_default', 1)->first();

        if ($segmentOne == $defaultLanguage->language_short_name || $segmentOne == null) {
            $this->lang = $defaultLanguage->language_id;
            $this->langname = $defaultLanguage->language_short_name;
        }else {
            $getLanguage = Language::where('language_short_name', $segmentOne)->first();
            if ($getLanguage) {
                $this->lang = $getLanguage->language_id;
                $this->langname = $getLanguage->language_short_name;
            }else {
                $this->lang = $defaultLanguage->language_id;
                $this->langname = $defaultLanguage->language_short_name;
            }
        }
    }

    public function authControl($model, $type = 'read')
    {

        $userPermission = auth()->guard('adtrpanel')->user();

        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray($model, $type));

    }
}
