<?php



namespace App\Http\Controllers;



use App\Models\Category;

use App\Models\CategoryDetail;

use Illuminate\Http\Request;



class CategoryController extends Controller

{

    public function index($slug)

    {

        $lang     = $this->lang;

        $langname = $this->langname;

        $category = CategoryDetail::whereSlug($slug)->where('language_id',$lang)->first();

        if(is_null($category)){

            abort(404);

        }

        $articles = $category->articles->where('language_id',$lang);

        $hrefLang_cats = CategoryDetail::where('category_id', $category->category_id)->get();

        $breadcrumb = [

            'baslik' => $category->category_name,

            'links' => [

                0 => [

                    'text' => trans('general.home'),

                    'url' => route('anasayfa')

                ],

                1 => [

                    'text' => $category->category_name,

                    'url' => route('category', $category->slug)

                ]

            ]

        ];

        $canonical = route('category', $category->slug);

        return view('themes.' . config('site_settings.themes_dir') . '.category', compact('category', 'articles', 'breadcrumb', 'canonical','lang', 'hrefLang_cats', 'langname'));

    }

    public function amp($slug)
    {
        $lang     = $this->lang;

        $langname = $this->langname;

        $category = CategoryDetail::whereSlug($slug)->firstorFail();
        $articles = $category->articles;
        $breadcrumb = [
            'baslik' => $category->category_name,
            'links' => [
                0 => [
                    'text' => 'Anasayfa',
                    'url' => route('anasayfa')
                ],
                1 => [
                    'text' => $category->category_name,
                    'url' => route('category', $category->slug)
                ]
            ]
        ];
        $canonical = route('category', $category->slug);
        return view('themes.' . config('site_settings.themes_dir') . '.amp.category', compact('category', 'articles', 'breadcrumb', 'canonical', 'lang'));
    }

}

