<?php


namespace App\Http\Controllers;


use App\Models\Blog;
use App\Models\StaticMetas;

use App\Models\BlogDetail;

use App\Models\Rating;

use Illuminate\Http\Request;


class BlogController extends Controller

{

    public function index()

    {



        $lang = $this->lang;
        $langname = $this->langname;
        $blogs = BlogDetail::where('status', 1)->where('language_id', $lang)->orderByDesc('blog_id')->paginate(10);
        $related_blogs = BlogDetail::where('status', 1)->where('language_id', $lang)->orderByDesc('views')->paginate(10);

        $breadcrumb = [
            'baslik' => 'Blog',
            'links' => [
                0 => [
                    'text' => __('general.home'),
                    'url' => route('anasayfa')
                ],
                1 => [
                    'text' => 'Blog',
                    'url' => route('blogs')
                ],
            ]

        ];

        $static_meta = StaticMetas::where('page_slug', 'blog')->first();

        $href_langs = [];
        $dir = '../resources/lang';
        $langs = array_diff(scandir($dir), array('..', '.'));
        $langs = array_values($langs);
        $hrefLang_languages = \App\Models\Language::all();

        foreach ($hrefLang_languages as $hrefLang_language) {
            if (in_array($hrefLang_language->language_short_name, $langs)) {
                \App::setLocale($hrefLang_language->language_short_name);
                $href_lang = $hrefLang_language->language_short_name;
                if ($hrefLang_language->language_short_name == "tr") {
                    $url = '/' . \Lang::get('urls.blog_url');
                } else {
                    $url = '/' . $hrefLang_language->language_short_name . '/' . \Lang::get('urls.blog_url');
                }
                $href_langs[] = [
                    'href_lang' => $href_lang,
                    'url' => url('/') . $url
                ];
            }
        }
        \App::setLocale($langname);

        return view('themes.' . config('site_settings.themes_dir') . '.blog.blogs', compact('blogs', 'breadcrumb', 'lang', 'langname', 'static_meta', 'href_langs', 'related_blogs'));

    }

    public function blog($slug)

    {

        $lang = $this->lang;
        $langname = $this->langname;

        $blogs = BlogDetail::where('status', 1)->where('language_id', $lang)->orderByDesc('blog_id')->inRandomOrder()->limit(10)->get();
        $blog = BlogDetail::where('status', 1)->whereSlug($slug)->firstOrFail();
        $hrefLang_blogs = BlogDetail::where('blog_id', $blog->blog_id)->get();

        $breadcrumb = [

            'baslik' => $blog->blog_title,

            'links' => [

                0 => [

                    'text' => __('general.home'),

                    'url' => route('anasayfa')

                ],

                1 => [

                    'text' => 'Blog',

                    'url' => route('blog')

                ],

                [

                    'text' => $blog->blog_title,

                    'url' => route('blog', $blog->slug)

                ]

            ]

        ];

        //toc kontrol
        $blog->blog_content = $this->tocControl($blog->blog_content);
        $like = Rating::where('blog_id', $blog->blog_id)->where('rating', 1)->get()->count();
        $dislike = Rating::where('blog_id', $blog->blog_id)->where('rating', 0)->get()->count();

        $href_langs = [];
        $dir    = '../resources/lang';
        $langs = array_diff(scandir($dir), array('..', '.'));
        $langs = array_values($langs);
        $hrefLang_languages = \App\Models\Language::all();
        $i = 0;

        foreach ($hrefLang_languages as $hrefLang_language) {
            if (in_array($hrefLang_language->language_short_name, $langs)) {
                if(!empty($hrefLang_blogs[$i]->slug)) {
                    \App::setLocale($hrefLang_language->language_short_name);
                    $href_lang = $hrefLang_language->language_short_name;
                    if ($hrefLang_language->language_short_name == "tr") {
                        $url = '/' . \Lang::get('urls.blog_url').'/'.$hrefLang_blogs[$i]->slug;
                    } else {
                        $url = '/' . $hrefLang_language->language_short_name . '/' . \Lang::get('urls.blog_url').'/'.$hrefLang_blogs[$i]->slug;
                    }
                    $href_langs[] = [
                        'href_lang' => $href_lang,
                        'url' => url('/') . $url
                    ];
                    $i++;
                }
            }
        }
        \App::setLocale($langname);

        return view('themes.' . config('site_settings.themes_dir') . '.blog.blog_detail', compact('blog', 'breadcrumb', 'hreflang_blogs', 'like', 'dislike', 'lang', 'langname', 'hrefLang_blogs', 'blogs', 'href_langs', 'other_blogs'));

    }

    public function blogAmp($slug)
    {

        $lang = $this->lang;
        $langname = $this->langname;
        $blog = BlogDetail::where('status', 1)->whereSlug($slug)->firstOrFail();
        $breadcrumb = [
            'baslik' => $blog->blog_title,
            'links' => [
                0 => [
                    'text' => 'Anasayfa',
                    'url' => route('anasayfa')
                ],
                1 => [
                    'text' => 'Blog',
                    'url' => route('blogs')
                ],
                [
                    'text' => $blog->blog_title,
                    'url' => null
                ]
            ]
        ];
        //toc kontrol
        $blog->blog_content = $this->tocControl($blog->blog_content);
        return view('themes.' . config('site_settings.themes_dir') . '.amp.blogcontent', compact('blog', 'breadcrumb'));
    }

    protected static function tocControl($content)

    {

        if (strstr($content, "[toc]")) {

            preg_match_all('@<h2.*?>(.*?)<\/h2>@si', $content, $toclist);

            $toc = '<ul class="grilistele"><h2>İçindekiler</h2>';

            $i = 0;

            foreach ($toclist[0] as $tocl) {

                $mtocl = str_replace('<h2', '<h2 id="' . str_slug(strip_tags($tocl)) . '-' . $i . '"', $tocl);

                $content = str_replace($tocl, $mtocl, $content);

                $toc .= '<li><a href="#' . str_slug(strip_tags($tocl)) . '-' . $i . '">';

                $toc .= strip_tags($tocl);

                $toc .= '</a></li>';

                $i++;

            }

            $toc .= '</ul>';

        } else {

            $toc = '';

        }

        $content = str_replace('[toc]', $toc, $content);

        return $content;

    }

}

