<?php

namespace App\Http\Controllers;

use App\Models\Article;

use App\Models\ArticleDetail;

use App\Models\Category;

use App\Models\CategoryDetail;

use App\Models\Rating;

use Illuminate\Http\Request;

class ArticleController extends Controller

{

    public function index($category_slug, $article_slug)

    {

        $lang = $this->lang;

        $langname = $this->langname;

        $category = CategoryDetail::whereSlug($category_slug)->where('language_id', $lang)->firstOrFail();

        $article = ArticleDetail::whereSlug($article_slug)->where('category_id', $category->category_id)->where('status', 1)->where('language_id', $lang)->firstOrFail();

        $hreflang_articles = ArticleDetail::where('article_id', $article->article_id)->get();

        $ssses = $article->ssses;

        $breadcrumb = [

            'baslik' => $article->article_title,

            'links' => [

                0 => [

                    'text' => trans('general.home'),

                    'url' => route('anasayfa')

                ],

                1 => [

                    'text' => $category->category_name,

                    'url' => route('category', $category->slug)

                ],

                2 => [

                    'text' => $article->article_title,

                    'url' => url()->current()

                ]

            ]

        ];

        //toc kontrol

        $article->article_content = $this->tocControl($article->article_content);

        $like = Rating::where('article_id', $article->article_id)->where('rating', 1)->get()->count();

        $dislike = Rating::where('article_id', $article->article_id)->where('rating', 0)->get()->count();

        return view('themes.' . config('site_settings.themes_dir') . '.article', compact('category', 'article', 'breadcrumb', 'ssses', 'like', 'dislike', 'lang', 'langname', 'hreflang_articles'));

    }

    public function amp($category_slug, $article_slug)
    {
        $lang = $this->lang;
        $langname = $this->langname;
        $category = CategoryDetail::whereSlug($category_slug)->firstOrFail();
        $article = ArticleDetail::whereSlug($article_slug)->where('status', 1)->firstOrFail();
        $ssses = $article->ssses;
        //toc kontrol
        $article->article_content = $this->tocControl($article->article_content);
        return view('themes.' . config('site_settings.themes_dir') . '.amp.articlecontent', compact('category', 'article', 'ssses', 'lang', 'langname'));
    }

    protected static function tocControl($content)

    {

        if (strstr($content, "[toc]")) {

            preg_match_all('@<h2.*?>(.*?)<\/h2>@si', $content, $toclist);

            $toc = '<ul class="grilistele"><h2>İçindekiler</h2>';

            $i = 0;

            foreach ($toclist[0] as $tocl) {

                $mtocl = str_replace('<h2', '<h2 id="' . str_slug(strip_tags($tocl)) . '-' . $i . '"', $tocl);

                $content = str_replace($tocl, $mtocl, $content);

                $toc .= '<li><a href="#' . str_slug(strip_tags($tocl)) . '-' . $i . '">';

                $toc .= strip_tags($tocl);

                $toc .= '</a></li>';

                $i++;

            }

            $toc .= '</ul>';

        } else {

            $toc = '';

        }

        $content = str_replace('[toc]', $toc, $content);

        return $content;

    }

}