<?php



namespace App\Http\Controllers;



use App\Models\AppointmentSubjectDetail;
use App\Models\Comment;
use App\Models\Contact;
use App\Models\Emails;
use App\Models\Question;
use App\Models\Rating;
use App\Models\RatingIp;
use App\Models\Randevu;
use App\Models\Sss;
use Http\Env\Response;
use Illuminate\Http\Request;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Mail;


class AjaxController extends Controller

{

    public function randevuKayit()

    {

        $var = \request('randevu_tarihi');

        $date = str_replace('/', '-', $var);

        $dateX= date('Y-m-d', strtotime($date));

        $this->validate(\request(), [

            'adsoyad' => 'required|max:30',

            'telefon' => 'required|',

            'randevu_tarihi' => 'required',

            'subject_id' => 'required|integer',

        ]);

        $data = [

            'adsoyad' => request('adsoyad'),

            'telefon' => request('telefon'),

            'randevu_tarihi' =>$dateX,

            'subject_id' => request('subject_id')

        ];

        $find_subject = AppointmentSubjectDetail::where('subject_id', request('subject_id'))->where('language_id', request('language_id'))->first();

        $maildata = [
            'adsoyad' => request('adsoyad'),
            'eposta' => request('eposta'),
            'telefon' => request('telefon'),
            'cinsiyet' => request('cinsiyet'),
            'randevu_alan' => $find_subject->name,
            'randevu_tarihi' => request('randevu_tarihi')
        ];
        Mail::send('themes.fbm.emails.randevuBilgiMail', $maildata, function($message) use($maildata)
        {
            $message->to('info@fbm.com.tr', "FBM Bilgilendirme")
                ->subject('Fbm.com.tr üzerinden randevu kaydı.')
                ->replyTo('info@fbm.com.tr', 'fbm');
        });

        $insert = Randevu::create($data);

        if (!$insert) {

            return response()->json([

                'sonuc' => 'err',

            ]);

        }

        return response()->json([

            'sonuc' => 'ok',

            'dateStrtotime'  => $dateX,

            'randevu'   => \request('randevu_tarihi')

        ]);



    }

    public function blog_rated()

    {

        $a = "no";



        $blog_id = request('blog_id');

        $type = request('type');

        if (!empty($blog_id) && ($type == true || $type == false)) {

            $ip_check = RatingIp::where('blog_id', $blog_id)->where('ip', request()->ip())->where('created_at', '>', Carbon::now()->subDays(2))->first();

            if ($ip_check == null) {



                Rating::create(

                    [

                        'blog_id' => $blog_id,

                        'rating' => $type

                    ]

                );

                RatingIp::updateOrCreate(

                    [

                        'blog_id' => $blog_id,

                        'ip' => request()->ip(),



                    ],

                    [

                        'created_at' => now()

                    ]

                );

                $a = "ok";

            } else {

                $a = "no";

            }

            $like = Rating::where('blog_id', $blog_id)->where('rating', 1)->get()->count();

            $dislike = Rating::where('blog_id', $blog_id)->where('rating', 0)->get()->count();

        } else {



        }





        return response()->json(['like' => $like, 'dislike' => $dislike, 'status' => $a]);

    }

    public function addEmail(){

        $subscriptionsData= request()->only('email');

        $validateData = [

            'email'       =>'required|email|max:100|min:10'

        ];



        $validator = \Validator::make($subscriptionsData,$validateData);



        if($validator->fails()){

            $errors = $validator->errors();

            return response()->json([

                'verr'       => $errors

            ]);

        }



        $subscription = new Emails();

        $subscription->email = request('email');

        if($subscription->save()){

            return response()->json([

                'okk'             => 'E-Posta bültenimize başarı ile kaydoldunuz.'

            ]);

        }

        else

        {

            return response()->json([

                'querr'        => 'Üzgünüz bu eposta mevcut :('

            ]);

        }

    }

    public function article_rated()

    {

        $a = "no";



        $article_id = request('article_id');

        $type = request('type');

        if (!empty($article_id) && ($type == true || $type == false)) {

            $ip_check = RatingIp::where('article_id', $article_id)->where('ip', request()->ip())->where('created_at', '>', Carbon::now()->subDays(2))->first();

            if ($ip_check == null) {



                Rating::create(

                    [

                        'article_id' => $article_id,

                        'rating' => $type

                    ]

                );

                RatingIp::updateOrCreate(

                    [

                        'article_id' => $article_id,

                        'ip' => request()->ip(),



                    ],

                    [

                        'created_at' => now()

                    ]

                );

                $a = "ok";

            } else {

                $a = "no";

            }

            $like = Rating::where('article_id', $article_id)->where('rating', 1)->get()->count();

            $dislike = Rating::where('article_id', $article_id)->where('rating', 0)->get()->count();

        } else {



        }





        return response()->json(['like' => $like, 'dislike' => $dislike, 'status' => $a]);

    }

    public function yorumGonder()
    {
        $data = request()->all();

        if ($data['captcha'] != '') {
            if ($data['captcha'] == $data['captchacode']) {
                unset($data['captcha']);
                unset($data['captchacode']);

                Comment::create($data);

                return response()->json([
                    'sonuc' => 'ok'
                ]);
            } else {
                return response()->json([
                    'sonuc' => 'captchaerror'
                ]);
            }
        } else {
            return response()->json([
                'sonuc' => 'nocaptcha'
            ]);
        }

    }

    public function contactFormGonder()
    {
        $data = request()->all();

        if ($data['captcha'] != '') {
            if ($data['captcha'] == $data['captchacode']) {
                unset($data['captcha']);
                unset($data['captchacode']);
                $mail = [
                    "name" => $data['name'],
                    "email" => $data['email'] ? $data['email'] : null,
                    "phone" => $data['phone'],
                    "subject" => $data['subject'],
                    "mesaj" => $data['message']
                ];

                /*Mail::send('themes.fbm.emails.contact_mail', $mail, function($message) use($mail)
                {
                    $message->to('info@fbm.com.tr', "FBM Bilgilendirme")
                        ->subject('Fbm.com.tr üzerinden iletişim kaydı.')
                        ->replyTo('info@fbm.com.tr', 'fbm');
                });*/

                $create_content = Contact::create($data);

                if ($create_content) {
                    $status = "ok";
                }else {
                    $status = "no";
                }

            } else {

                $status = "captchaerror";

            }

        } else {

            $status = "nocaptcha";

        }

        return response()->json(['status' => $status]);

    }

    public function set_article_rating() {

        $article_id = request('article_id');
        $value = request('value');

        if (!empty(Cookie::get('article_id')) && Cookie::get('article_id') == $article_id) {
            $status = "ip_exist";
        }else {

            $set_rating = Rating::create([
                'article_id' => $article_id,
                'rating' => $value
            ]);

            $add_rating_ip = RatingIp::create([
                'ip' => request()->ip(),
                'article_id' => $article_id,
            ]);

            if ($set_rating && $add_rating_ip) {
                Cookie::queue('article_id', $article_id, '2880', null, null, true, true);
                $status = "ok";
            }else {
                $status = "no";
            }

        }

        return response()->json(['status' => $status]);

    }

    public function set_blog_rating() {

        $blog_id = request('blog_id');
        $value = request('value');

        if (!empty(Cookie::get('blog_id')) && Cookie::get('blog_id') == $blog_id) {
            $status = "ip_exist";
        }else {

            $set_rating = Rating::create([
                'blog_id' => $blog_id,
                'rating' => $value
            ]);

            $add_rating_ip = RatingIp::create([
                'ip' => request()->ip(),
                'blog_id' => $blog_id,
            ]);

            if ($set_rating && $add_rating_ip) {
                Cookie::queue('blog_id', $blog_id, '2880', null, null, true, true);
                $status = "ok";
            }else {
                $status = "no";
            }

        }

        return response()->json(['status' => $status]);
    }

    public function set_video_rating() {

        $video_id = request('video_id');
        $value = request('value');

        if (!empty(Cookie::get('video_id')) && Cookie::get('video_id') == $video_id) {
            $status = "ip_exist";
        }else {

            $set_rating = Rating::create([
                'video_id' => $video_id,
                'rating' => $value
            ]);

            $add_rating_ip = RatingIp::create([
                'ip' => request()->ip(),
                'video_id' => $video_id,
            ]);

            if ($set_rating && $add_rating_ip) {
                Cookie::queue('video_id', $video_id, '2880', null, null, true, true);
                $status = "ok";
            }else {
                $status = "no";
            }

        }

        return response()->json(['status' => $status]);
    }

    public function set_sss_rating() {

        if (empty(Cookie::get('rating'))) {
            Cookie::queue('rating', '1', 2880);
        }

        $datas = request()->only('sss_id', 'type');
        $find_sss = Sss::where('sss_id', $datas['sss_id']);

        if (!Cookie::get('rating')) {
            if ($datas['type'] == 1) {

                $last_rate = $find_sss->first()->like;
                $new_rate = $last_rate + 1;
                $update = $find_sss->update(['like' => $new_rate]);

            }elseif($datas['type'] == 0) {

                $last_rate = $find_sss->first()->dislike;
                $new_rate = $last_rate + 1;
                $update = $find_sss->update(['dislike' => $new_rate]);

            }else {
                dd("undefined type");
            }

            if ($update) {
                $status = "ok";
            }else {
                $status = "no";
            }
            return response()->json(['like' => $find_sss->first()->like, 'dislike' => $find_sss->first()->dislike, 'status' => $status]);
        }else {
            return response()->json(['status' => 'rating_has']);
        }

    }

    public function set_page_rating() {

        $page_id = request('page_id');
        $value = request('value');

        if (!empty(Cookie::get('page_id')) && Cookie::get('page_id') == $page_id) {
            $status = "ip_exist";
        }else {

            $set_rating = Rating::create([
                'page_id' => $page_id,
                'rating' => $value
            ]);

            $add_rating_ip = RatingIp::create([
                'ip' => request()->ip(),
                'page_id' => $page_id,
            ]);

            if ($set_rating && $add_rating_ip) {
                Cookie::queue('page_id', $page_id, '2880', null, null, true, true);
                $status = "ok";
            }else {
                $status = "no";
            }

        }

        return response()->json(['status' => $status]);
    }

    public function set_comment_rating() {

        $comment_id = request('comment_id');
        $type = request('type');

        if (!empty(Cookie::get('comment'.$comment_id)) && Cookie::get('comment'.$comment_id) == $comment_id) {
            $status = "ip_exist";
        }else {

            $comment = Comment::where('comment_id', $comment_id)->first();
            $comment->$type = $comment->$type + 1;
            $comment->save();

            $comment = commentStatuses($comment->comment_id);

            Cookie::queue('comment'.$comment_id, $comment_id, '2880', null, null, true, true);
            $status = "ok";

        }

        return response()->json(['status' => $status, 'comment' => isset($comment) ? $comment : null]);

    }

    public function askQuestion() {

        if (empty(request('name')) || empty(request('doctor')) || empty(request('tel')) || empty(request('question'))) {
            $status = "empty_inputs";
        }else {

            $create_question = Question::create([
                'doctor_id' => \request('doctor'),
                'name_surname' => \request('name'),
                'phone_number' => \request('tel'),
                'question' => \request('question')
            ]);

            if ($create_question) {
                $status = "ok";
            }else {
                $status = "no";
            }

        }

        return response()->json(['status' => $status]);

    }

}