<?php


namespace App\Http\Controllers\Adtrpanel;


use App\Models\ArticleDetail;

use App\Models\Language;

use App\Models\User;

use App\Models\VideoGalleriesDetail;

use App\Models\VideoGallery;

use App\Models\VideoGalleryCategoriesDetail;

use App\Models\VideoGalleryCategory;

use function GuzzleHttp\Psr7\str;

use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\Validator;

use Intervention\Image\Facades\Image;


class VideoGalleryController extends Controller

{

    public function index()

    {

        $userPermission = auth()->guard('adtrpanel')->user();

        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('VideoGallery', 'read'));

        $video_list = VideoGalleriesDetail::groupBy('video_id')->paginate(15);

        return view('adtrpanel.videogallery.index', compact('video_list'));

    }


    public function galleries()

    {

        $userPermission = auth()->guard('adtrpanel')->user();

        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('VideoGalleryCategory', 'read'));

        $gallery_list = VideoGalleryCategoriesDetail::groupBy('gallery_id')->paginate(20);

        return view('adtrpanel.videogallery.galeries', compact('gallery_list'));

    }


    public function galleryform($id = null)

    {

        $userPermission = auth()->guard('adtrpanel')->user();

        if ($id != null) {

            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('VideoGalleryCategory', 'update'));

            $gallery = VideoGalleryCategoriesDetail::where('gallery_id', $id)->get();

        } else {

            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('VideoGalleryCategory', 'create'));

        }

        $languages = Language::all();

        return view('adtrpanel.videogallery.galleryform', compact('gallery', 'languages'));

    }


    public function gallerysave($id = null)

    {

        $userPermission = auth()->guard('adtrpanel')->user();

        if ($id != null) {

            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('VideoGalleryCategory', 'update'));

        } else {

            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('VideoGalleryCategory', 'create'));

        }


        $datas = request()->only('gallery_name', 'meta_title', 'meta_description', 'status', 'in_gallery', 'slug');

        $create_video_gallery_cats = VideoGalleryCategory::updateOrCreate(

            [

                'gallery_id' => $id,

            ]

        )->gallery_id;


        $languages = Language::all();


        foreach ($languages as $language) {


            if (!empty($datas['gallery_name'][$language->language_short_name]) || !empty($datas['meta_title'][$language->language_short_name]) || !empty($datas['meta_description'][$language->language_short_name]) || !empty($datas['status'][$language->language_short_name]) || !empty($datas['in_gallery'][$language->language_short_name])) {


                $create_video_gallery_cats_details = VideoGalleryCategoriesDetail::updateOrCreate(

                    [

                        'gallery_id' => $create_video_gallery_cats,

                        'language_id' => $language->language_id

                    ],

                    [

                        'gallery_name' => $datas['gallery_name'][$language->language_short_name],

                        'meta_title' => $datas['meta_title'][$language->language_short_name],

                        'meta_description' => $datas['meta_description'][$language->language_short_name],

                        'status' => $datas['status'][$language->language_short_name],

                        'in_gallery' => $datas['in_gallery'][$language->language_short_name],

                    ]

                )->gallery_details_id;


                if (!empty($datas['slug'][$language->language_short_name])) {

                    $slug = $datas['slug'][$language->language_short_name];

                } else {

                    $slug = str_slug($datas['gallery_name'][$language->language_short_name]);

                }

                if (videoGallerySlugKontrol($slug) != 0) {

                    $gallery_slugs = VideoGalleryCategoriesDetail::whereSlug($slug)->get();

                    foreach ($gallery_slugs as $gallery_slug) {

                        if ($gallery_slug->gallery_id != $create_video_gallery_cats) {

                            $slug = $slug . '-' . (videoGallerySlugKontrol($slug) + 1);

                        }

                    }

                }


                $add_slug = VideoGalleryCategoriesDetail::where('gallery_details_id', $create_video_gallery_cats_details)->update(['slug' => $slug]);


                if (request()->hasFile('video_gallery_image')) {

                    $this->validate(request(), [

                            'video_gallery_image' => 'image|mimes:jpg,jpeg,png|max:2048'

                        ]

                    );


                    $img = Image::make(request()->file('video_gallery_image'));

                    $img->fit(800, 450);

                    $path = 'uploads/videogaleri/' . 'video_' . rand() . '.png';

                    $img->save(public_path($path));


                    $push_image_datas = VideoGalleryCategoriesDetail::where('gallery_details_id', $create_video_gallery_cats_details)->update(['image' => $path, 'alt_and_title' => request('alt_and_title')]);


                }

            }


        }


        return redirect()->route('adtrpanel.videogallery.categories');

    }


    public function form($id = null)

    {

        $userPermission = auth()->guard('adtrpanel')->user();

        if ($id != null) {

            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('VideoGallery', 'update'));

            $videos = VideoGalleriesDetail::where('video_id', $id)->get();

        } else {

            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('VideoGallery', 'create'));

        }


        $languages = Language::all();

        $videoGalleryCats = VideoGalleryCategoriesDetail::groupBy('gallery_id')->get();


        return view('adtrpanel.videogallery.form', compact('id', 'videos', 'languages', 'videoGalleryCats'));

    }


    public function save($id = null)

    {

        $userPermission = auth()->guard('adtrpanel')->user();

        if ($id != null) {

            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('VideoGallery', 'update'));

        } else {

            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('VideoGallery', 'create'));

        }

        $datas = request()->only('gallery', 'video_name', 'video_path', 'video_description', 'status', 'in_gallery');

        $images = request()->file('video_image');

        $create_video_gallery = VideoGallery::updateOrCreate(

            [

                'video_id' => $id,

            ]

        )->video_id;


        $languages = Language::all();


        foreach ($languages as $language) {


            if (!empty($datas['video_name'][$language->language_short_name]) || !empty($datas['video_path'][$language->language_short_name]) || !empty($datas['video_description'][$language->language_short_name]) || !empty($datas['status'][$language->language_short_name]) || !empty($datas['gallery'][$language->language_short_name])) {


                $create_video_gallery_details = VideoGalleriesDetail::updateOrCreate(

                    [

                        'video_id' => $create_video_gallery,

                        'language_id' => $language->language_id

                    ],

                    [

                        'gallery_id' => $datas['gallery'],

                        'video_name' => $datas['video_name'][$language->language_short_name],

                        'video_path' => $datas['video_path'][$language->language_short_name],

                        'video_description' => $datas['video_description'][$language->language_short_name],

                        'status' => $datas['status'],

                        'in_gallery' => $datas['in_gallery'],

                    ]

                )->video_details_id;


            }

            if (empty(request()->file('video_image')[$language->language_short_name])) {

                if (strstr($datas['video_path'][$language->language_short_name], 'youtube') || strstr($datas['video_path'][$language->language_short_name], 'youtu') || strstr($datas['video_path'][$language->language_short_name], 'youtu.be')) {

                    $videoURL = $datas['video_path'][$language->language_short_name];

                    $thumbnailSize = "hqdefault";

                    if($videoURL)
                    {

                        if (preg_match('%(?:youtube(?:-nocookie)?.com/(?:[^/]+/.+/|(?:v|e(?:mbed)?)/|.*[?&]v=)|youtu.be/)([^"&?/ ]{11})%i', $videoURL, $id))
                        {
                            //video id`sini yazdıralım.
                            $videoId = $id[1];
                        }
                        //Görseli gösterelim.
                        $image = "http://img.youtube.com/vi/$videoId/$thumbnailSize.jpg";
                        $image_name = $datas['video_name'][$language->language_short_name].'.jpg';
                        copy($image, public_path('uploads/videogaleri/'.$image_name));
                        $push_image_datas = VideoGalleriesDetail::where('video_details_id', $create_video_gallery_details)->update(['video_image' => '/uploads/videogaleri/'.$image_name]);
                    }

                }

            }else {

                if (request()->hasFile('video_image')) {

                    $this->validate(request(), [

                            'image' => 'image|mimes:jpg,jpeg,png|max:2048'

                        ]

                    );


                    $img = Image::make(request()->file('video_image')[$language->language_short_name]);

                    $resim = \request('video_image')[$language->language_short_name];


                    $img->fit(800, 450);

                    $path = '/uploads/videogaleri/' . 'video_' . rand() . '.' . $resim->getClientOriginalName();

                    $img->save(public_path($path));


                    $push_image_datas = VideoGalleriesDetail::where('video_details_id', $create_video_gallery_details)->update(['video_image' => $path]);


                }

            }


        }


        return redirect()->route('adtrpanel.videogallery');

    }


    public function activate($id)

    {

        $userPermission = auth()->guard('adtrpanel')->user();

        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('VideoGallery', 'update'));

        VideoGalleriesDetail::where('video_id', $id)->update(['status' => 1]);

        return redirect()->route('adtrpanel.videogallery');

    }


    public function deactivate($id)

    {

        $userPermission = auth()->guard('adtrpanel')->user();

        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('VideoGallery', 'update'));

        VideoGalleriesDetail::where('video_id', $id)->update(['status' => 0]);

        return redirect()->route('adtrpanel.videogallery');

    }


    public function deleteVidCategory($gallery_id)

    {

        $userPermission = auth()->guard('adtrpanel')->user();

        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('VideoGalleryCategoriesDetail', 'delete'));

        $delVidCat = VideoGalleryCategory::where('gallery_id', $gallery_id)->first();

        $image_path = $delVidCat->video_image;

        @unlink(public_path($image_path));

        $delete = VideoGalleryCategory::where('gallery_id', $gallery_id)->delete();

        if (!$delete) {

            dd('eerr');

        }


        return redirect()->back()->with('message_variable', 'success')->with('message', 'Galeri Başarıyla Silindi');

    }


    public function delete($id)

    {

        $userPermission = auth()->guard('adtrpanel')->user();

        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('VideoGallery', 'delete'));

        $video = VideoGalleriesDetail::where('video_id', $id)->first();

        $image_path = $video->video_image;

        @unlink($image_path);

        $delete = VideoGalleriesDetail::where('video_id', $id)->delete();

        if (!$delete) {

            dd('eerr');

        }

        return redirect()->back()->with('message_variable', 'success')->with('message', 'Video Başarıyla Silindi');

    }

}

