<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\MyModel;
use App\Models\Permission;
use App\Models\Role;
use App\Models\RoleUser;
use App\Models\User;
use App\Models\UserBillingAddress;
use App\Models\UserDeliveryAddress;
use App\Models\UserDetail;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Validator;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Str;

class UserController extends Controller
{
    public function index()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('User', 'read'));
        request()->flash();
        if(request('aranan')){
            $user_list = User::where('name', 'LIKE', '%'.request('aranan').'%')
                ->orWhere('email', 'LIKE', '%'.request('aranan').'%')
                ->orderByDesc('created_at')
                ->paginate(15);
        }else{
            $user_list = User::orderByDesc('created_at')->paginate(15);
        }

        return view('adtrpanel.users.index', compact('user_list'));
    }

    public function userForm($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        $roles = Role::all();
        if ($id != null)
        {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('User', 'update'));
            $user = User::find($id);
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('User', 'create'));
        }
        return view('adtrpanel.users.userform', compact('user', 'roles'));
    }

    public function save($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        if ($id != null)
        {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('User', 'update'));
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('User', 'create'));
        }
        $user_data = request()->only('name', 'email', 'is_admin', 'status');
        $vdata = [
            'name' => 'required',
            'email' => 'required|email',
        ];
        if (request()->filled('password'))
        {
            $user_data['password'] = request('password');
            $vdata['password'] = 'min:8|max:20';
        }
        $validator = Validator::make($user_data, $vdata);
        if ($validator->fails()) {
            $errors = $validator->errors();
            return redirect()->back()->withInput()->withErrors($errors);
        } else {
            $user_data['password'] = Hash::make(request('password'));
            if ($id != null)
            {
                //Bilgiler güncelleniyor
                $user = User::find($id);
                $user->update($user_data);
                UserDetail::updateOrCreate(
                    [
                        'user_id' => $id
                    ],
                    [
                        'user_id' => $user->id,
                        'avatar' => '/uploads/users/2.jpg',
                        'alt_and_title' => $user_data['name'],

                    ]
                );
                RoleUser::where('user_id', $user->id)->update(['role_id' => request('role_id')]);
                $ndata = ['message_variable' => 'success', 'message' => 'Kullanıcı Başarıyla Güncellendi'];
            } else {
                //Yeni Kullanıcı Ekleniyor
                $user_data['activation_code'] = Str::random(60);
                $user_data['is_admin']  = 1;
                $user = User::create($user_data);
                UserDetail::create([
                    'user_id' => $user->id,
                    'avatar' => '/uploads/users/2.jpg',
                    'alt_and_title' => $user_data['name']
                ]);
                RoleUser::create(
                    [
                        'role_id' => request('role_id'),
                        'user_id' => $user->id
                    ]
                );
                $ndata = ['message_variable' => 'success', 'message' => 'Kullanıcı Başarıyla Eklendi'];
            }
        }
        if(request()->filled('kaydet')) {
            return redirect(route('adtrpanel.users'))->with($ndata);
        }
        if(request()->filled('kaydetvedevamet')) {
            return redirect(route('adtrpanel.users.edit', $user->id))->with($ndata);
        }
    }

    public function delete($id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('User', 'delete'));
        UserDetail::where('user_id', $id)->delete();
        User::destroy($id);
        $ndata = ['message_variable' => 'success', 'message' => 'Kullanıcı Başarıyla Silindi'];
        return redirect()->route('adtrpanel.users')->with($ndata);
    }

    public function groups()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Role', 'read'));
        $userGroups = Role::all();
        return view('adtrpanel.users.groups', compact('userGroups'));
    }

    public function groupsForm($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        $roles = Role::all();
        if ($id != null)
        {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Role', 'update'));
            $userGroup = Role::find($id);
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Role', 'create'));
        }
        return view('adtrpanel.users.groupform', compact('userGroup', 'roles'));
    }

    public function groupsSave($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        if ($id != null)
        {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Role', 'update'));
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Role', 'create'));
        }
        $group_data = request()->only('description');
        $group_data['name'] = str_slug(request('name'), '_');
        $vdata = [
            'name' => 'required',
            'description' => 'required',
        ];
        $validator = Validator::make($group_data, $vdata);
        if ($validator->fails()) {
            $errors = $validator->errors();
            return redirect()->back()->withInput()->withErrors($errors);
        } else {
            if ($id != null)
            {
                //Bilgiler güncelleniyor
                $userGroup = Role::find($id);
                $userGroup->update($group_data);
                $ndata = ['message_variable' => 'success', 'message' => 'Kullanıcı Grubu Başarıyla Güncellendi'];
            } else {
                $userGroup = Role::create($group_data);
                $ndata = ['message_variable' => 'success', 'message' => 'Kullanıcı Grubu Başarıyla Eklendi'];
                $models = MyModel::all();
                foreach($models as $model)
                {
                    Permission::updateOrCreate(
                        [
                            'role_id' => $userGroup->id,
                            'model_id' => $model->model_id
                        ],
                        [
                            'create' => 0,
                            'update' => 0,
                            'read' => 1,
                            'delete' => 0,
                        ]
                    );
                }
            }
        }
        if(request()->filled('kaydet')) {
            return redirect(route('adtrpanel.usergroups'))->with($ndata);
        }
        if(request()->filled('kaydetvedevamet')) {
            return redirect(route('adtrpanel.usergroups.edit', $userGroup->id))->with($ndata);
        }
    }

    public function groupsDelete($id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Role', 'delete'));
        Role::destroy($id);
        $ndata = ['message_variable' => 'success', 'message' => 'Kullanıcı Grubu Başarıyla Silindi'];
        return redirect()->route('adtrpanel.usergroups')->with($ndata);
    }

    public function groupsAuthEdit($role_id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Role', 'update'));

        $auth_list = Permission::where('role_id', $role_id)->get();
        return view('adtrpanel.users.groupauths', compact('auth_list', 'role_id'));
    }

    public function groupsAuthKaydet($role_id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Role', 'update'));
        $permissions = request('permissions');
        $create = request('create');
        $update = request('update');
        $delete = request('delete');
        $read = request('read');
        foreach($permissions as $value)
        {
            if(isset($create[$value]))
            {
                Permission::where('permission_id', $value)->update(['create' => 1]);
            } else {
                Permission::where('permission_id', $value)->update(['create' => 0]);
            }
            if(isset($update[$value]))
            {
                Permission::where('permission_id', $value)->update(['update' => 1]);
            } else {
                Permission::where('permission_id', $value)->update(['update' => 0]);
            }
            if(isset($delete[$value]))
            {
                Permission::where('permission_id', $value)->update(['delete' => 1]);
            } else {
                Permission::where('permission_id', $value)->update(['delete' => 0]);
            }
            if(isset($read[$value]))
            {
                Permission::where('permission_id', $value)->update(['read' => 1]);
            } else {
                Permission::where('permission_id', $value)->update(['read' => 0]);
            }
        }
        $ndata = ['message_variable' => 'success', 'message' => 'Kullanıcı Grubu Yetkileri Başarıyla Güncellendi'];
        return redirect()->route('adtrpanel.usergroups.authedit', $role_id)->with($ndata);
    }
}
