<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Http\Controllers\Controller;
use App\Models\Language;
use App\Models\StaticMetaDetail;
use App\Models\StaticMetas;
use App\Models\User;
use Illuminate\Http\Request;

class StaticMetaController extends Controller
{

    public function index() {

        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('StaticMetas', 'read'));
        $static_metas = StaticMetas::paginate(15);

        return view('adtrpanel.static_metas.index', compact('static_metas'));

    }

    public function form($id = null) {

        $userPermission = auth()->guard('adtrpanel')->user();

        if ($id == null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('StaticMetas', 'create'));
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('StaticMetaDetail', 'create'));
        }else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('StaticMetas', 'update'));
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('StaticMetaDetail', 'update'));
            $static_meta = StaticMetas::where('meta_id', $id)->first();
        }

        $languages = Language::all();

        return view('adtrpanel.static_metas.staticMetasForm', compact('static_meta', 'languages'));

    }

    public function save($id = null) {

        $userPermission = auth()->guard('adtrpanel')->user();

        if ($id == null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('StaticMetas', 'create'));
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('StaticMetaDetail', 'create'));
        }else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('StaticMetas', 'update'));
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('StaticMetaDetail', 'update'));
        }

        $languages = Language::all();

        $datas = request()->only('page_title', 'page_slug', 'page_meta_title', 'page_meta_description');

        if (!empty($datas['page_title']) || !empty($datas['page_name'])) {

            $create_static_page = StaticMetas::updateOrCreate(
                [
                    'meta_id' => $id,
                    'page_slug' => $datas['page_slug']
                ],
                [
                    'page_name' => $datas['page_title']
                ]
            )->meta_id;

        }

        foreach ($languages as $language) {

            if (!empty($datas['page_meta_title'][$language->language_short_name]) || !empty($datas['page_meta_description'][$language->language_short_name])) {

                $create_static_page_detail = StaticMetaDetail::updateOrCreate(
                    [
                        'meta_id' => $create_static_page,
                        'language_id' => $language->language_id,
                    ],
                    [
                        'meta_title' => $datas['page_meta_title'][$language->language_short_name],
                        'meta_description' => $datas['page_meta_description'][$language->language_short_name],
                    ]
                );

            }

        }

        return redirect()->route('adtrpanel.staticmetas');

    }

}
