<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\ArticleDetail;
use App\Models\Language;
use App\Models\Sss;
use App\Models\SssDetail;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class SssController extends Controller
{

    public function index() {

        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Sss', 'read'));
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('SssDetail', 'read'));
        $ssses = Sss::paginate(15);

        return view('adtrpanel.sss.index', compact('ssses'));

    }

    public function form($id = null) {

        $userPermission = auth()->guard('adtrpanel')->user();

        if ($id == null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Sss', 'create'));
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('SssDetail', 'create'));
        }else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Sss', 'update'));
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('SssDetail', 'update'));
            $sss = Sss::where('sss_id', $id)->first();
        }

        $languages = Language::all();
        $articles = ArticleDetail::all();
        return view('adtrpanel.sss.sssForm', compact('sss', 'languages', 'articles'));

    }

    public function save($id = null) {

        $userPermission = auth()->guard('adtrpanel')->user();

        if ($id == null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Sss', 'create'));
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('SssDetail', 'create'));
        }else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Sss', 'update'));
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('SssDetail', 'update'));
        }

        $languages = Language::all();
        $datas = request()->only('article_id', 'question', 'answer', 'status', 'rank');

        $create_sss = Sss::updateOrCreate(
            [
                'sss_id' => $id,
                'article_id' => $datas['article_id'],
            ],
            [
                'rank' => $datas['rank'],
                'status' => $datas['status']
            ]
        )->sss_id;

        foreach ($languages as $language) {
            if (!empty($datas['question'][$language->language_short_name]) || !empty($datas['answer'][$language->language_short_name])){

                $create_sss_detail = SssDetail::updateOrCreate(
                    [
                        'sss_id' => $create_sss,
                        'language_id' => $language->language_id
                    ],
                    [
                        'question' => $datas['question'][$language->language_short_name],
                        'answer' => $datas['answer'][$language->language_short_name],
                    ]
                );

            }
        }

        return redirect()->route('adtrpanel.sss');


    }

    public function delete($id) {

        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Sss', 'delete'));

        $delete_sss = Sss::where('sss_id', $id)->delete();
        return redirect()->route('adtrpanel.sss');
    }

    public function activated($id) {

        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Sss', 'update'));
        Sss::where('sss_id', $id)->update([
            'status' => 1
        ]);
        return redirect()->route('adtrpanel.sss');

    }

    public function deactivated($id) {

        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Sss', 'update'));
        Sss::where('sss_id', $id)->update([
            'status' => 0
        ]);
        return redirect()->route('adtrpanel.sss');

    }

}
