<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\Language;
use App\Models\Slider;
use App\Models\SliderDetail;
use App\Models\User;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class SliderController extends Controller
{
    public function index()
    {
        $slider_list = SliderDetail::orderByDesc('slider_id')->groupBy('slider_id')->paginate(15);
        return view('adtrpanel.sliders.index', compact('slider_list'));
    }

    public function slidersForm($slider_id = null)
    {
        $languages = Language::all();
        if ($slider_id != null) {
            $sliders = SliderDetail::where('slider_id', $slider_id)->get();
        }
        return view('adtrpanel.sliders.slidersform', compact('sliders', 'languages'));
    }

    public function save($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('SliderDetail', 'update'));
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('SliderDetail', 'create'));
        }

        $general_datas = request()->only('title', 'url', 'text', 'url', 'slider_status', 'rank');
        // Oluşturulan blogun idsini al
        $globSliderID = null;
        if ($id != null) {
            $slider_id = $id;
        } else {
            $addSlider = Slider::insert(['created_at' => date('Y-m-d'), 'updated_at' => date('Y-m-d')]);
            if (!$addSlider) {
                dd('ErR add $addSlider');
            }

            $checkSlider = Slider::orderByDesc('slider_id')->first();
            $slider_id = $checkSlider->slider_id;
        }

        $languages = Language::all();
        if (count($languages) > 0) {
            foreach ($languages as $language) {

                if (!empty($general_datas['title'][$language->language_short_name])) {

                    $globSliderID = $slider_id;

                    if (empty($general_datas['rank'][$language->language_short_name])) {
                        $checkLastSliderRank = SliderDetail::orderByDesc('slider_detail_id')->first();
                        if ($checkLastSliderRank) {
                            $general_datas['rank'][$language->language_short_name] =
                                (int)$checkLastSliderRank->rank + 1;
                        } else {
                            $general_datas['rank'][$language->language_short_name] = 1;
                        }
                    }

                    $create_slider_detail = SliderDetail::updateOrCreate(
                        [
                            'slider_id' => $globSliderID,
                            'language_id' => $language->language_id
                        ],
                        [
                            'title' => $general_datas['title'][$language->language_short_name],
                            'url' => $general_datas['url'][$language->language_short_name],
                            'text' => $general_datas['text'][$language->language_short_name],
                            'slider_status' => $general_datas['slider_status'][$language->language_short_name],
                            'rank' => $general_datas['rank'][$language->language_short_name],
                        ]
                    );

                    if (!$create_slider_detail) {
                        dd('$create_slider_detail err');
                    }
                }
            }


        }
        $slider_data = array();
        if (request()->hasFile('image')) {
            $resim = request()->file('image');
            $image_info = getimagesize($_FILES["image"]["tmp_name"]);
            $image_width = $image_info[0];
            $image_height = $image_info[1];
            $image_name = str_replace($resim->getClientOriginalExtension(), '', $resim->getClientOriginalName());
            $dosyaAdi = str_slug($image_name);
            $yeni = $_SERVER['DOCUMENT_ROOT'] . '/public/uploads/sliders/' . $dosyaAdi . '-' . $image_width . 'x' . $image_height . '.' . $resim->getClientOriginalExtension();
            $i = 1;
            for (; file_exists($yeni);) {
                $yeni = $_SERVER['DOCUMENT_ROOT'] . '/public/uploads/sliders/' . $dosyaAdi . '-' . $i . '-' . $image_width . 'x' . $image_height . '.' . $resim->getClientOriginalExtension();
                $i++;
            }
            $dosya = str_replace($_SERVER['DOCUMENT_ROOT'] . '/public/uploads/sliders/', '', $yeni);
            if ($resim->isValid()) {
                $resim->move('uploads/sliders', $dosya);
            }
            $slider_data['image'] = '/uploads/sliders/' . $dosya;
        } else {
            $checkImage = SliderDetail::where('slider_id', $globSliderID)->first();
            if ($checkImage) {
                $slider_data['image'] = $checkImage->image;
            }
        }


        if (request()->hasFile('mobil_image')) {
            $resim = request()->file('mobil_image');
            $image_info = getimagesize($_FILES["mobil_image"]["tmp_name"]);
            $image_width = $image_info[0];
            $image_height = $image_info[1];
            $image_name = str_replace($resim->getClientOriginalExtension(), '', $resim->getClientOriginalName());
            $dosyaAdi = str_slug($image_name);
            $yeni = $_SERVER['DOCUMENT_ROOT'] . '/public/uploads/sliders/' . $dosyaAdi . '-' . $image_width . 'x' . $image_height . '.' . $resim->getClientOriginalExtension();
            $i = 1;
            for (; file_exists($yeni);) {
                $yeni = $_SERVER['DOCUMENT_ROOT'] . '/public/uploads/sliders/' . $dosyaAdi . '-' . $i . '-' . $image_width . 'x' . $image_height . '.' . $resim->getClientOriginalExtension();
                $i++;
            }
            $dosya = str_replace($_SERVER['DOCUMENT_ROOT'] . '/public/uploads/sliders/', '', $yeni);
            if ($resim->isValid()) {
                $resim->move('uploads/sliders', $dosya);
            }
            $slider_data['mobil_image'] = '/uploads/sliders/' . $dosya;
        } else {
            $checkImage = SliderDetail::where('slider_id', $globSliderID)->where('mobil_image', '!=', null)->first();
            if ($checkImage) {
                $slider_data['mobil_image'] = $checkImage->mobil_image;
            }
        }


        if (count($slider_data) > 0) {
            $updateSlider = SliderDetail::where('slider_id', $globSliderID)->update($slider_data);
        }

        return redirect()->route('adtrpanel.sliders');
    }

    public function delete($id)
    {
        $sliders = SliderDetail::where('slider_id', $id)->get();
        foreach ($sliders as $slider) {
            $image_path = public_path($slider->image);
            if (file_exists(public_path($slider->image))) {
                @unlink($image_path);

            }
            if (file_exists(public_path($slider->mobil_image))) {
                $mobil_image_path = public_path($slider->mobil_image);
                @unlink($mobil_image_path);
            }
            SliderDetail::where('slider_id', $id)->delete();
            Slider::where('slider_id', $id)->delete();
        }
        return redirect()->route('adtrpanel.sliders');
    }

    public function activated($slider_id)
    {
        $slider = SliderDetail::where('slider_id', $slider_id)->update(['slider_status' => 1]);
        return redirect()->route('adtrpanel.sliders');
    }

    public function deactivated($slider_id)
    {
        $slider = SliderDetail::where('slider_id', $slider_id)->update(['slider_status' => 0]);
        return redirect()->route('adtrpanel.sliders');
    }
}
