<?php
namespace App\Http\Controllers\Adtrpanel;
use App\Models\SiteSetting;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Twitter;
use File;
use App\Models\SocialMedia;
class SitesettingsController extends Controller
{
    public function list_files($dir)
    {
        $arr = [];
        if(is_dir($dir))
        {
            if($handle = opendir($dir))
            {
                while(($file = readdir($handle)) !== false)
                {
                    if($file != "." && $file != ".." && $file != "Thumbs.db"/*Bazı sinir bozucu windows dosyaları.*/)
                    {
                        $arr[] = $file;
                    }
                }
                closedir($handle);
            }
        }
        return $arr;
    }

    public function index()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('SiteSetting', 'read'));
        $themes = $this->list_files($_SERVER['DOCUMENT_ROOT'] . '/resources/views/themes');
        if (request()->filled('kaydet'))
        {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('SiteSetting', 'update'));
            if(request()->filled('countdown'))
            {
                $sure = strtotime(request('countdown'));
            }
            if(request()->hasFile('site_logo'))
            {
                $site_logo = request()->file('site_logo');
                $dosya = 'logo.'.$site_logo->extension();
                if(file_exists('/uploads/site/'.$dosya))
                {
                    unlink('/uploads/site/'.$dosya);
                }
                if ($site_logo->isValid())
                {
                    $site_logo->move('uploads/site', $dosya);
                }
                $logo_file = '/uploads/site/' . $dosya;
            }
            if(request()->hasFile('favicon_png'))
            {
                $faviconpng = request()->file('favicon_png');
                $dosya = 'favicon.png';
                if(file_exists('/uploads/site/'.$dosya))
                {
                    unlink('/uploads/site/'.$dosya);
                }
                if ($faviconpng->isValid())
                {
                    $faviconpng->move('uploads/site', $dosya);
                }
                $favicon_png_file = '/uploads/site/' . $dosya;
            }
            if(request()->hasFile('favicon_ico'))
            {
                $faviconico = request()->file('favicon_ico');
                $dosya = 'favicon.ico';
                if(file_exists('/uploads/site/'.$dosya))
                {
                    unlink('/uploads/site/'.$dosya);
                }
                if ($faviconico->isValid())
                {
                    $faviconico->move('uploads/site', $dosya);
                }
                $favicon_ico_file = '/uploads/site/' . $dosya;
            }
            $data = request()->all();
            unset($data['site_logo']);
            unset($data['favicon_png']);
            unset($data['favicon_ico']);
            unset($data['_token']);
            unset($data['kaydet']);
            unset($data['sure']);
            if(isset($logo_file))
            {
                $data['site_logo'] = $logo_file;
            }
            if(isset($favicon_ico_file))
            {
                $data['favicon_ico'] = $favicon_ico_file;
            }
            if(isset($favicon_png_file))
            {
                $data['favicon_png'] = $favicon_png_file;
            }
            if(isset($sure))
            {
                $data['countdown'] = $sure;
            }
            foreach ($data as $key => $value)
            {
                SiteSetting::where('entry', $key)->update(['value' => $value]);
            }
            return redirect()->route('adtrpanel.siteayarlari')
                ->with(['message_variable' => 'success', 'message' => 'Site Ayarları Başarıyla güncellendi']);
        }
        $site_settings = SiteSetting::all();
        return view('adtrpanel.sitesettings', compact('site_settings', 'themes'));
    }
    public function addNewSetting()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('SiteSetting', 'create'));
        return view('adtrpanel.newsetting', compact('site_settings'));
    }
    public function save()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('SiteSetting', 'create'));
        $setting_data = [
            'type' => request('setting_type'),
            'option' => request('setting_name'),
            'entry' =>  str_slug(request('setting_entry'), '_')
        ];
        if (request('serialized') == 'null')
        {
            $setting_data['serialized'] = null;
        } else {
            $setting_data['serialized'] = request('serialized');
        }

        SiteSetting::create($setting_data);
        return redirect()->route('adtrpanel.siteayarlari')
            ->with(['message_variable' => 'success', 'message' => 'Yeni Ayar Başarıyla Eklendi']);
    }
}
