<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\CategoryDetail;
use App\Models\Language;
use App\Models\Product;
use App\Models\ProductDetail;
use App\Models\ProductToCategory;
use App\Models\ProductImage;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;


class ProductController extends Controller
{
    public function index()
    {

        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Product', 'read'));
        $products = Product::join('product_descriptions','id','=','product_id')->get();

        return view('adtrpanel.product.product', compact('products'));
    }


    public function form($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        if ($id != null) {

            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Product', 'update'));

            $product = Product::join('product_descriptions','id','=','product_id')->where('id',$id)->get();
            $productImages = ProductImage::where('product_id',$id)->get();
            $product_to_category = ProductToCategory::where('product_id',$id)->get();
            $categories = array();

            $count = -1;

            foreach ($product_to_category as $item){
                $count++;
              $detail =  CategoryDetail::where('category_id',$item->category_id)->get();

              foreach ($detail as $d){

                  $categories[$count]  = array(
                      'category_name' => $d->category_name,
                      'product_id'    => $id,
                      'category_id'   => $d->category_id
                  );
              }

            }

        } else {

            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Product', 'create'));
        }

        $languages = Language::all();
        return view('adtrpanel.product.productform', compact('product', 'languages', 'productImages','categories'));
    }

    //Tamamlandı-> Tekrar test et
    public function save($id = null)
    {


        $userPermission = auth()->guard('adtrpanel')->user();
        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Product', 'update'));
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Product', 'create'));
        }

        //alt_and_title
        $datas = request()->only('product_name', 'product_description', 'meta_title', 'meta_description', 'slug','model','price','status','seo_description','alt_and_title');

        //Create

        $languages = Language::all();

        $endId = 0;

        if($id == null){




            $product             = new Product();
            $product_description = new ProductDetail();




            foreach ($languages as $language) {

                    $product->model = $datas['model'][$language->language_short_name];
                    $product->price = $datas['price'][$language->language_short_name];
                    $product->status = $datas['status'][$language->language_short_name];
                    $product->alt_and_title = $datas['alt_and_title'];


                    $product_description->name = $datas['product_name'][$language->language_short_name];
                    $product_description->description = $datas['product_description'][$language->language_short_name];
                    $product_description->meta_title = $datas['meta_title'][$language->language_short_name];
                    $product_description->meta_description = $datas['meta_description'][$language->language_short_name];
                    $product_description->seo_description = $datas['seo_description'][$language->language_short_name];
                    $product_description->slug = str_slug($datas['slug'][$language->language_short_name]);

            }

            $product->save();
            $endId = $product->id;

            $product_description->product_id = $endId;
            $product_description->save();


            if(isset(\request()['product_category']) && !empty(\request()['product_category'])){
                foreach (\request()['product_category'] as $value){
                    $product_to_category = new ProductToCategory();
                    $product_to_category->product_id = $endId;
                    $product_to_category->category_id = $value;

                    $product_to_category->save();
                }
            }
            if (request()->hasFile('image')) {

                $img = \Image::make(request()->file('image'));
                $resim = \request()->file('image');

                $img->fit(800, 450);
                $path = 'assets/frontend/urunresimler/'. $resim->getClientOriginalName();
                $img->save(public_path($path));

                $product  = Product::find($endId);
                $product->image = $path;
                $product->save();

            }

            if(isset(request()['product_image'])){

                foreach (request()->allFiles()['product_image'] as $key=>$val){
                    $product_image       = new ProductImage();
                    $img = \Image::make($val);
                    $resim = $val;
                    $img->fit(800, 450);
                    $path = 'assets/frontend/urunresimler/'. $resim->getClientOriginalName();
                    $img->save(public_path($path));

                    $product_image->product_id = $endId;
                    $product_image->image = $path;
                    $product_image->sort_order = 0;

                    $product_image->save();

                }

            }

        }else{


            ProductToCategory::where('product_id',$id)->delete();
            //product_to_categories
            if(!empty(\request()['product_category'])){

                foreach (\request()['product_category'] as $value){
                        $product_to_category = new ProductToCategory();
                        $product_to_category->product_id = $id;
                        $product_to_category->category_id = $value;

                        $product_to_category->save();
                }
            }

            //Products tablosundaki image alındı.
            $product_image = Product::where('id', $id)->get()->first();
            $image_path = $product_image->image;
            if(isset(\request()['image'])){

                if(\File::exists(public_path($image_path))){
                    unlink(public_path($image_path));
                }
            }

            $product             = Product::find($id);
            $product_description = ProductDetail::where('product_id',$id)->delete();
            $product_description = new ProductDetail();

            foreach ($languages as $language) {

                $product->model = $datas['model'][$language->language_short_name];
                $product->price = $datas['price'][$language->language_short_name];
                $product->status = $datas['status'][$language->language_short_name];
                $product->alt_and_title = $datas['alt_and_title'];


                $product_description->name = $datas['product_name'][$language->language_short_name];
                $product_description->description = $datas['product_description'][$language->language_short_name];
                $product_description->meta_title = $datas['meta_title'][$language->language_short_name];
                $product_description->meta_description = $datas['meta_description'][$language->language_short_name];
                $product_description->seo_description = $datas['seo_description'][$language->language_short_name];
                $product_description->slug = str_slug($datas['slug'][$language->language_short_name]);

            }

            $product->save();
            $endId = $product->id;

            $product_description->product_id = $endId;
            $product_description->save();


            if (request()->hasFile('image')) {


                $img = \Image::make(request()->file('image'));
                $resim = \request()->file('image');
                $img->fit(800, 450);
                $path = 'assets/frontend/urunresimler/'. $resim->getClientOriginalName();
                $img->save(public_path($path));

                $product  = Product::find($endId);
                $product->image = $path;
                $product->save();

            }

            if(request()->has('product_image')){

                foreach (request()['product_image'] as $key=>$val){
                    if(is_array($val)){

                    }else{

                        $product_image       = new ProductImage();

                        $img = \Image::make($val);
                        $img->fit(800, 450);
                        $path = 'assets/frontend/urunresimler/'. $resim->getClientOriginalName();

                        $img->save(public_path($path));

                        $product_image->product_id = $endId;
                        $product_image->image = $path;
                        $product_image->sort_order = 0;

                        $product_image->save();
                    }
                }
            }


        }
        return redirect()->route('adtrpanel.product');
    }



    //Tamamlandı
    public function activate($id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Product', 'update'));
        Product::where('id', $id)->update(['status' => 1]);
        return redirect()->route('adtrpanel.product');
    }

    //Tamamlandı
    public function deactivate($id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Product', 'update'));
        Product::where('id', $id)->update(['status' => 0]);
        return redirect()->route('adtrpanel.product');
    }

    //Tamamlandı
    public function delete($id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Product', 'delete'));

        //Products tablosundaki image alındı.
        $product_image = Product::where('id', $id)->get()->first();
        $image_path = $product_image->image;

        if(\File::exists(public_path($image_path))){
            unlink(public_path($image_path));
        }

        //Product_images tablosundaki image'ler alındı
        $product_images = ProductImage::where('product_id',$id)->get();

        foreach ($product_images as $val){
                $image_path = $val->image;

                 if(\File::exists(public_path($image_path))){
                     unlink(public_path($image_path));
                 }
        }

        $productImageDelete  = Product::where('id',$id)->delete();
        $productImagesDelete = ProductImage::where('product_id',$id)->delete();
        $productDescription  = ProductDetail::where('product_id',$id)->delete();



        return redirect()->back()->with('message_variable', 'success')->with('message', 'Ürün Başarıyla Silindi');
    }

    public function ajaxImageDelete(){


          $imageDelete =  ProductImage::where('id', request('id'))->get();


          if(\File::exists(public_path($imageDelete[0]['image']))){
             @unlink(public_path($imageDelete[0]['image']));
          }
          ProductImage::where('id', request('id'))->delete();

          return response()->json(['result' => 'success']);

    }

}