<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\Language;
use App\Models\Photo;
use App\Models\PhotoGallery;
use App\Models\PhotoGalleryDetail;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\File;
use Intervention\Image\Facades\Image;

class PhotoGalleryController extends Controller
{
    public function index()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('PhotoGalleryDetail', 'read'));
        $galleryList = PhotoGalleryDetail::groupBy('photo_gallery_id')->paginate(20);
        return view('adtrpanel.imagegallery.galeries', compact('galleryList'));
    }

    public function form($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('PhotoGalleryDetail', 'update'));
            $gallery = PhotoGalleryDetail::where('photo_gallery_id', $id)->get();
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('PhotoGalleryDetail', 'create'));
        }
        $languages = Language::all();
        return view('adtrpanel.imagegallery.galleryform', compact('gallery', 'languages'));
    }

    public function gallerysave($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('PhotoGalleryDetail', 'update'));
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('PhotoGalleryDetail', 'create'));
        }


        $datas = request()->only('gallery_name', 'meta_title', 'meta_description', 'status', 'in_gallery', 'slug','alt_and_title');

        $createPhotoGallery = PhotoGallery::updateOrCreate(
            [
                'photo_gallery_id' => $id,
            ]
        );

        $languages = Language::all();

        foreach ($languages as $language) {

            if (!empty($datas['gallery_name'][$language->language_short_name])) {

                $createPhotoGalleryDetail = PhotoGalleryDetail::updateOrCreate(
                    [
                        'photo_gallery_id' => $createPhotoGallery->photo_gallery_id,
                        'language_id' => $language->language_id
                    ],
                    [
                        'gallery_name' => $datas['gallery_name'][$language->language_short_name],
                        'meta_title' => $datas['meta_title'][$language->language_short_name],
                        'meta_description' => $datas['meta_description'][$language->language_short_name],
                        'status' => $datas['status'][$language->language_short_name],
                        'in_gallery' => $datas['in_gallery'][$language->language_short_name],
                        'alt_and_title' => $datas['alt_and_title']
                    ]
                )->photo_gallery_detail_id;

                if (!empty($datas['slug'][$language->language_short_name])) {
                    $slug = $datas['slug'][$language->language_short_name];
                }else {
                    $slug = str_slug($datas['gallery_name'][$language->language_short_name]);
                    if (photoGallerySlugKontrol($slug) > 0) {
                        $slug = $slug . '-' . rand(0,99);
                    }
                }

                $add_slug = PhotoGalleryDetail::where('photo_gallery_id', $createPhotoGallery->photo_gallery_id)->where('language_id', $language->language_id)->update(['slug' => $slug]);

            }

        }

        if (request()->has('photo_gallery_image')) {
            $img = Image::make(request()->file('photo_gallery_image'));
            $img_name = "/uploads/fotogaleri/".rand().'.'.request()->file('photo_gallery_image')->getClientOriginalExtension();
            $img->save(public_path($img_name));
            $add_image = PhotoGalleryDetail::where('photo_gallery_id', $createPhotoGallery->photo_gallery_id)->update(['image' => $img_name, 'alt_and_title' => request('alt_and_title')]);
        }

        return redirect()->route('adtrpanel.imagegallery');
    }

    public function activate($id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('PhotoGalleryDetail', 'update'));
        PhotoGalleryDetail::where('photo_gallery_id', $id)->update(['status' => 1]);
        return redirect()->route('adtrpanel.imagegallery');
    }

    public function deactivate($id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('PhotoGalleryDetail', 'update'));
        PhotoGalleryDetail::where('photo_gallery_id', $id)->update(['status' => 0]);
        return redirect()->route('adtrpanel.imagegallery');
    }

    public function delete($id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('PhotoGalleryDetail', 'delete'));
        $image = PhotoGalleryDetail::where('photo_gallery_id', $id)->first();
        $image_path = $image->image;
        if(!empty($image_path)){
            unlink(public_path($image_path));
        }
        $imageDelt = PhotoGallery::where('photo_gallery_id', $id)->delete();
        if (!$imageDelt) {
            dd('eerr');
        }
        return redirect()->back()->with('message_variable', 'success')->with('message', 'Galeri Başarıyla Silindi');
    }
}