<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\Language;
use App\Models\Photo;
use App\Models\PhotoDetail;
use App\Models\PhotoGallery;
use App\Models\PhotoGalleryDetail;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class PhotoController extends Controller
{
    public function index()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('PhotoDetail', 'read'));
        $photos = PhotoDetail::groupBy('photo_id')->paginate(20);
        return view('adtrpanel.imagegallery.photos', compact('photos'));
    }

    public function form($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('PhotoDetail', 'update'));
            $photos = PhotoDetail::where('photo_id', $id)->get();
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('PhotoDetail', 'create'));
        }

        $photoGalleries = PhotoGalleryDetail::all();
        $languages = Language::all();
        return view('adtrpanel.imagegallery.photoform', compact('photos', 'languages', 'photoGalleries'));
    }


    public function save($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('PhotoDetail', 'update'));
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('PhotoDetail', 'create'));
        }

        $datas = request()->only('photo_name', 'photo_description', 'gallery', 'status', 'in_gallery');
        $create_photo = Photo::updateOrCreate(
            [
                'photo_id' => $id,
            ]
        )->photo_id;

        $languages = Language::all();

        foreach ($languages as $language) {

            if (!empty($datas['photo_name'][$language->language_short_name]) || !empty($datas['photo_description'][$language->language_short_name]) || !empty($datas['status'][$language->language_short_name]) || !empty($datas['gallery'][$language->language_short_name])) {
                $create_photo_detail = PhotoDetail::updateOrCreate(
                    [
                        'photo_id' => $create_photo,
                        'language_id' => $language->language_id
                    ],
                    [
                        'photo_gallery_id' => $datas['gallery'][$language->language_short_name],
                        'photo_name' => $datas['photo_name'][$language->language_short_name],
                        'photo_description' => $datas['photo_description'][$language->language_short_name],
                        'status' => $datas['status'][$language->language_short_name],
                        'in_gallery' => $datas['in_gallery'][$language->language_short_name]
                    ]
                )->photo_detail_id;

            }

            if (request()->hasFile('photo_image')) {
                $this->validate(request(), [
                        'photo_image['.$language->language_short_name.']' => 'image|mimes:jpg,jpeg,png|max:2048'
                    ]
                );
                if(isset(request()->file('photo_image')[$language->language_short_name])){
                    $img = \Image::make(request()->file('photo_image')[$language->language_short_name]);
                    $resim = \request()->file('photo_image')[$language->language_short_name];
                }
                $img->fit(800, 450);
                $path = 'uploads/fotogaleri/' . 'foto' . rand() . '.' . $resim->getClientOriginalName();
                $img->save(public_path($path));
                $push_image_datas = PhotoDetail::where('photo_detail_id', $create_photo_detail)->update(['photo_image' => $path]);

            }
        }

        return redirect()->route('adtrpanel.imagegallery.photos');
    }

    public function activate($id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('PhotoDetail', 'update'));
        PhotoDetail::where('photo_id', $id)->update(['status' => 1]);
        return redirect()->route('adtrpanel.imagegallery.photos');
    }

    public function deactivate($id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('PhotoDetail', 'update'));
        PhotoDetail::where('photo_id', $id)->update(['status' => 0]);
        return redirect()->route('adtrpanel.imagegallery.photos');
    }

    public function delete($id)
    {

        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('PhotoDetail', 'delete'));
        $image = PhotoDetail::where('photo_id', $id)->first();

        $image_path = $image->photo_image;
        if (!empty($image_path)) {
            @unlink(public_path($image_path));
        }
        $imageDelt = Photo::where('photo_id', $id)->delete();
        $photoDetail =PhotoDetail::where('photo_id',$id)->delete();

        if (!$imageDelt) {
            dd('eerr');
        }
        return redirect()->back()->with('message_variable', 'success')->with('message', 'Fotoğraf Başarıyla Silindi');
    }
}