<?php

namespace App\Http\Controllers\Adtrpanel;

use http\Env\Response;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Payment;

class PaymentController extends Controller
{
    public function index()
    {
        $payments = Payment::orderBy('created_at','desc')->get();

        return view('adtrpanel.payment.index', compact('payments'));
    }

    public function show($id)
    {

        $payment = Payment::where('payment_id', $id)->firstOrFail();

        return view('adtrpanel.payment.show', compact('payment'));
    }

    public function delete()
    {
        $ndata = ['message_variable' => 'error', 'message' => 'Silme işlemi yapılamadı.'];
        if (request()->has('payment_id')) {
            $id = request('payment_id');
            Payment::where('payment_id', $id)->delete();
            $ndata = ['message_variable' => 'success', 'message' => 'Silme işlemi başarılı.'];
        }


        return response()->json($ndata);
    }

}
