<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Http\Controllers\Controller;
use App\Models\PatientOperations;
use App\Models\Patients;
use App\Models\User;
use Carbon\Carbon;

class PatientController extends Controller
{
    public function index()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Patient', 'read'));
        if (request()->has('aranan')){
            $aranan = request('aranan');
            $patients = Patients::where('name', 'like', '%' . $aranan . '%')->orderBy('created_at', 'desc')->paginate(25);
        } else {
            $patients = Patients::orderBy('created_at', 'desc')->paginate(25);

        }

        return view('adtrpanel.hasta-takip.index', compact('patients'));
    }

    public function form($id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Patient', 'update'));
        $patient = Patients::find($id);

        return view('adtrpanel.hasta-takip.form', compact('patient'));
    }

    public function save($id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Patient', 'update'));
        Patients::find($id)->update([
            'patients_note' => request('note'),
        ]);

        return redirect()->back()->with(['message_variable' => 'success', 'message' => 'Kaydınız Güncellenmiştir.']);
    }

    public function newPatient()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Patient', 'create'));

        if (request()->has('name') && request()->has('phone')) {
            if (request('name') && request('phone')) {
                $patient = Patients::create([
                    'name' => request('name'),
                    'phone' => request('phone'),
                    'patients_note' => request('note'),
                ]);
                if ($patient) {
                    $route = route('adtrpanel.hasta-takip.show', $patient->patient_id);
                    return response()->json(['result' => 'success', 'redirect_url' => $route]);

                }
            }
        }

        return response()->json(['result' => 'err']);
    }

    public function newOperations()
    {

        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Patient', 'create'));

        if (request()->has('patient_id') && request()->has('subject') && request()->has('step') && request()->has('operator') && request()->has('current') && request()->has('price')) {

            $operation = PatientOperations::create([
                'patient_id' => request('patient_id'),
                'subject' => request('subject'),
                'steps' => request('step'),
                'operator' => request('operator'),
                'price' => request('price'),
                'current' => request('current'),
                'operation_date' => Carbon::parse(request('operation_date'))->format('d-m-Y H:i:s'),
                'note' => request('note')
            ]);
            $operations = PatientOperations::where('patient_id', request('patient_id'))->get();
            $views = view('adtrpanel.hasta-takip.operation_row', compact('operations'))->render();
            $ndata = ['result' => 'success', 'html' => $views];
        } else {
            $ndata = ['result' => 'error'];
        }

        return response()->json($ndata);
    }

    public function delete()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Patient', 'delete'));

        if (request('type') == "operation") {
            PatientOperations::find(request('id'))->delete();
            $operations = PatientOperations::where('patient_id', request('pid'))->get();
            $views = view('adtrpanel.hasta-takip.operation_row', compact('operations'))->render();
            $ndata = ['result' => 'success', 'html' => $views];
        } else {
            Patients::find(request('id'))->delete();
            $ndata = ['result' => 'success', 'id' => request('id')];
        }

        return response()->json($ndata);
    }

    protected function hastaAra()
    {

        $aranan = request('aranan');

        $patients = Patients::where('name', 'like', '%' . $aranan . '%')->paginate(25);
        $views = view('adtrpanel.hasta-takip.hasta-ara', compact('patients'))->render();

        return response()->json(['html' => $views]);
    }


}
