<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\Language;
use App\Models\Page;
use App\Models\PageDetail;
use App\Models\User;
use function GuzzleHttp\Psr7\str;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator;

class PageController extends Controller
{
    public function index()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Page', 'read'));
        $page_list = PageDetail::orderByDesc('created_at')->groupBy('page_id')->paginate(15);
        return view('adtrpanel.pages.index', compact('page_list'));
    }

    public function pagesForm($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Page', 'update'));
            $page = PageDetail::where('page_id', $id)->get();
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Page', 'create'));
        }
        $languages = Language::all();
        return view('adtrpanel.pages.pagesform', compact('page', 'languages'));
    }

    public function save($id = null)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Page', 'update'));
        } else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Page', 'create'));
        }

        $general_datas = request()->only('page_title', 'page_content', 'status', 'rank');
        $meta_datas = request()->only('page_meta_title', 'page_meta_description', 'page_meta_keywords', 'slug');

        $languages = Language::all();
        $globPageId = null;

        if ($id != null) {
            $page_id = $id;
        } else {
            $addPage = Page::insert(['created_at' => date('Y-m-d'), 'updated_at' => date('Y-m-d')]);
            if (!$addPage) {
                dd('ErR add Article');
            }
            $checkPage = Page::orderByDesc('page_id')->first();
            $page_id = $checkPage->page_id;
        }
        do_action('adtrpanel.page.save.after', ['page_id' => $page_id, 'template' => request('template')]);

        foreach ($languages as $language) {

            if (!empty($general_datas['page_title'][$language->language_short_name]) || !empty($general_datas['page_content'][$language->language_short_name]) || !empty($general_datas['status'][$language->language_short_name])) {

                $globPageId = $page_id;
                if (empty($general_datas['rank'][$language->language_short_name])) {
                    $checkLastPageRank = PageDetail::orderByDesc('page_details_id')->first();
                    if ($checkLastPageRank) {
                        $general_datas['rank'][$language->language_short_name] =
                            (int)$checkLastPageRank->rank + 1;
                    } else {
                        $general_datas['rank'][$language->language_short_name] = 1;
                    }
                }

                $create_page_detail = PageDetail::updateOrCreate(
                    [
                        'page_id' => $globPageId,
                        'language_id' => $language->language_id
                    ],
                    [
                        'page_title' => $general_datas['page_title'][$language->language_short_name],
                        'page_content' => $general_datas['page_content'][$language->language_short_name],
                        'status' => $general_datas['status'][$language->language_short_name],
                        'rank' => $general_datas['rank'][$language->language_short_name],
                        'page_meta_title' => $meta_datas['page_meta_title'][$language->language_short_name],
                        'page_meta_description' => $meta_datas['page_meta_description'][$language->language_short_name],
                        'page_meta_keywords' => $meta_datas['page_meta_keywords'][$language->language_short_name],
                    ]
                );

                if (empty($meta_datas['slug'][$language->language_short_name])) {
                    $meta_data = str_slug($general_datas['page_title'][$language->language_short_name]);
                }else {
                    $meta_data = $meta_datas['slug'][$language->language_short_name];
                }
                if(!empty($meta_data)){
                    $push_meta_datas = PageDetail::where('page_details_id', $create_page_detail->page_details_id)->update(['slug' => $meta_data]);
                }


            }

        }

        return redirect()->route('adtrpanel.pages');

    }

    public function delete($page_id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Page', 'delete'));
        $page = Page::find($page_id);
        $page->delete();
        return redirect()->route('adtrpanel.pages');
    }

    public function activated($page_id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Page', 'update'));
        $page = PageDetail::where('page_id', $page_id)->update(['status' => 1]);
        return redirect()->route('adtrpanel.pages');
    }

    public function deactivated($page_id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Page', 'update'));
        $page = PageDetail::where('page_id', $page_id)->update(['status' => 0]);
        return redirect()->route('adtrpanel.pages');
    }
}
