<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\Language;
use App\Models\OurWork;
use App\Models\OurWorkDetail;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Intervention\Image\Facades\Image;

class OurWorksController extends Controller
{
    public function index() {

        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('OurWork', 'read'));

        $all_works = OurWork::orderByDesc('work_id')->paginate(10);

        return view('adtrpanel.works.index', compact('all_works'));

    }

    public function blogForm($id = null) {

        $userPermission = auth()->guard('adtrpanel')->user();

        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('OurWork', 'update'));
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('OurWorkDetail', 'create'));
            $work = OurWork::where('work_id', $id)->first();
        }else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('OurWork', 'create'));
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('OurWorkDetail', 'create'));
        }

        $languages = Language::all();

        return view('adtrpanel.works.workform', compact('work', 'languages'));

    }

    public function save($id = null) {

        $userPermission = auth()->guard('adtrpanel')->user();

        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('OurWork', 'update'));
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('OurWorkDetail', 'create'));
            $work = OurWork::where('work_id', $id)->first();
        }else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('OurWork', 'create'));
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('OurWorkDetail', 'create'));
        }

        $general_datas = request()->only('work_title', 'work_content');
        $meta_datas = request()->only('work_meta_title', 'work_meta_description', 'work_meta_keywords', 'slug', 'alt_and_title');
        $other_datas = request()->only('status', 'rank');
        $image_data = request()->file('image');

        $languages = Language::all();

        if (!empty($other_datas["status"])) {

            $img_name = null;
            if (request()->has('image')) {
                $img = Image::make($image_data);
                $img_name = 'uploads/works/'.strtolower(str_slug($general_datas['work_title']['tr'])).'.jpg';
                $img->save(public_path($img_name));
            }

            $create_work = OurWork::updateOrCreate(
                [
                    'work_id' => $id
                ],
                [
                    'status' => $other_datas['status'],
                    'rank' => $other_datas['rank'],
                    'image' => '/'.$img_name
                ]
            )->work_id;

            foreach ($languages as $language) {

                if (!empty($general_datas['work_title'][$language->language_short_name]) || !empty($general_datas['work_content'][$language->language_short_name])) {

                    if (
                        !empty(!$meta_datas['work_meta_title'][$language->language_short_name]) ||
                        !empty(!$meta_datas['work_meta_description'][$language->language_short_name]) ||
                        !empty(!$meta_datas['work_meta_keywords'][$language->language_short_name]) ||
                        !empty(!$meta_datas['alt_and_title'][$language->language_short_name])
                    ) {

                        if (!empty($meta_datas['slug'][$language->language_short_name])){
                            $slug = str_slug($meta_datas['slug'][$language->language_short_name]);
                        }else {
                            $slug = str_slug($general_datas['work_title'][$language->language_short_name]);
                            start:
                            $slug_exist = OurWorkDetail::whereSlug($slug)->where('work_id', '!=', $id)->where('language_id', $language->language_id)->first();
                            if (!empty($slug_exist)) {
                                $slug = $slug.'-'.(workSlugControl($slug)+1);
                                goto start;
                            }
                        }

                        $create_work_detail = OurWorkDetail::updateOrCreate(
                            [
                                'work_id' => $create_work,
                                'language_id' => $language->language_id
                            ],
                            [
                                'work_title' => $general_datas['work_title'][$language->language_short_name],
                                'work_content' => $general_datas['work_content'][$language->language_short_name],
                                'work_meta_title' => $meta_datas['work_meta_title'][$language->language_short_name],
                                'work_meta_description' => $meta_datas['work_meta_description'][$language->language_short_name],
                                'work_meta_keywords' => $meta_datas['work_meta_keywords'][$language->language_short_name],
                                'alt_and_title' => $meta_datas['alt_and_title'][$language->language_short_name],
                                'slug' => $slug
                            ]
                        );

                    }

                }

            }

        }

        return redirect()->route('adtrpanel.works');

    }

    public function activated($id) {

        $activated = OurWork::where('work_id', $id)->update(['status' => 1]);
        return redirect()->back();

    }

    public function deactivated($id) {

        $deactivated = OurWork::where('work_id', $id)->update(['status' => 0]);
        return redirect()->back();

    }

    public function delete($id) {

        $delete_work = OurWork::where('work_id', $id)->first();
        @unlink(public_path($delete_work->image));
        $delete_work->delete();
        return redirect()->route('adtrpanel.works');

    }

}
