<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\Language;
use App\Models\Menu;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;

class MenuController extends Controller
{
    public function index()
    {
        request()->flash();
        if(request('aranan')){
            $menu_list = Menu::Select('menu_name')
                ->where('menu_name', 'like', '%'.request('aranan').'%')
                ->orderByDesc('created_at')
                ->paginate(15);
        }else{
            $menu_list = Menu::orderByDesc('created_at')->paginate(15);
        }

        return view('adtrpanel.menus.index', compact('menu_list'));
    }

    public function menusform($id = null)
    {
        $languages = Language::all();

        if ($id != null)
        {
            $menu = Menu::find($id);
        }
        return view('adtrpanel.menus.menusform', compact('menu','languages'));
    }

    public function save($id = null)
    {
        $this->validate(request(), [
            'menu_name' => 'required|'
        ]);
        if ($id != null)
        {
            $menu = Menu::find($id);
            $menu->menu_name = request('menu_name');
            $menu->update();
            $ndata = ['message_variable' => 'success', 'message' => 'Menü Başarıyla Güncellendi'];
        } else {
            $menu = Menu::create([
                'menu_name' => request('menu_name'),
            ]);
            $ndata = ['message_variable' => 'success', 'message' => 'Menü Başarıyla Eklendi'];
        }
        return redirect()->route('adtrpanel.menus.new', $menu->menu_id)->with($ndata);
    }

    public function delete($menu_id)
    {
        Menu::find($menu_id)->delete();
        return redirect()->route('adtrpanel.menus');
    }
}
