<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\Language;
use App\Models\MedicalStaff;
use App\Models\MedicalStaffDetail;
use App\Models\User;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Intervention\Image\Facades\Image;

class MedicalStaffController extends Controller
{

    public function index() {

        $userPermission = auth()->guard('adtrpanel')->user();

        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('MedicalStaff', 'read'));

        $medical_staffs = MedicalStaff::paginate(10);

        return view('adtrpanel.medicalstaff.index', compact('medical_staffs'));

    }

    public function kadromuzForm($id = null) {

        $userPermission = auth()->guard('adtrpanel')->user();

        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('MedicalStaff','update'));
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('MedicalStaffDetail','update'));
            $medical_staff = MedicalStaff::where('medical_staff_id', $id)->first();
        }else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('MedicalStaff','create'));
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('MedicalStaffDetail','create'));
        }

        $languages = Language::all();

        return view('adtrpanel.medicalstaff.kadromuzform', compact('medical_staff', 'languages'));

    }

    public function save($id = null) {

        $userPermission = auth()->guard('adtrpanel')->user();

        if ($id != null) {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('MedicalStaff','update'));
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('MedicalStaffDetail','update'));
        }else {
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('MedicalStaff','create'));
            User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('MedicalStaffDetail','create'));
        }

        $datas = request()->only('type', 'name', 'surname', 'position', 'rank', 'instagram', 'facebook', 'email');
        $image_data = request()->file('image');

        $languages = Language::all();

        if (!empty($datas['type']) || !empty($datas['name']) || !empty($datas['surname']) || !empty($datas['rank'])) {

            $create_medical_staff = MedicalStaff::updateOrCreate(
                [
                    'medical_staff_id' => $id
                ],
                [
                    'type' => $datas['type'],
                    'name' => $datas['name'],
                    'surname' => $datas['surname'],
                    'rank' => $datas['rank']
                ]
            )->medical_staff_id;

            foreach ($languages as $language) {

                if (!empty($datas['position'][$language->language_short_name])) {

                    if ($image_data) {

                        $img = Image::make($image_data);
                        $img_name = 'uploads/medical_staffs/'.strtolower(str_slug($datas['name'])).'-'.strtolower(str_slug($datas['surname'])).'.jpg';
                        $img->save(public_path($img_name));

                        $add_image = MedicalStaff::where('medical_staff_id', $create_medical_staff)->update(['image' => '/'.$img_name]);

                    }

                    $create_medical_staff_detail = MedicalStaffDetail::updateOrCreate(
                        [
                            'medical_staff_id' => $create_medical_staff,
                            'language_id' => $language->language_id
                        ],
                        [
                            'position' => $datas['position'][$language->language_short_name],
                            'instagram' => $datas['instagram'][$language->language_short_name],
                            'facebook' => $datas['facebook'][$language->language_short_name],
                            'email' => $datas['email'][$language->language_short_name]
                        ]
                    );

                }

            }

        }

        return redirect()->route('adtrpanel.kadromuz');

    }

    public function delete($id) {

        $find_staff = MedicalStaff::where('medical_staff_id', $id)->first();
        unlink(public_path($find_staff->image));
        $find_staff_detail = MedicalStaffDetail::where('medical_staff_id', $find_staff->medical_staff_id)->delete();
        $find_staff->delete();

        return redirect()->route('adtrpanel.kadromuz');

    }

}
