<?php

namespace App\Http\Controllers\Adtrpanel;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    public function login()
    {

        if (request()->isMethod('post')) {

            $this->validate(request(),[
                'email' =>  'required|email',
                'password'  =>  'required'
            ]);
            $datas = [
                'email' => request('email'),
                'password' => request('password'),
                'is_admin' => 1
            ];

            if(Auth::guard('adtrpanel')->attempt($datas, request()->has('remember-me')))
            {
                return redirect()->route('adtrpanel.anasayfa');
            }else {
                $errors = ['email' => 'Hatalı giriş'];
                return back()->withInput()->withErrors($errors);
            }
        }
        else {
            if(Auth::guard('adtrpanel')->check())
            {
                return redirect()->route('adtrpanel.anasayfa');
            } else {
                return view('adtrpanel.login');
            }
        }
    }

    public function logout()
    {
        Auth::guard('adtrpanel')->logout();
        request()->session()->flush();
        request()->session()->regenerate();

        return redirect()->route('adtrpanel.login');
    }
}
