<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\Language;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Input;
use Intervention\Image\Facades\Image;

class LanguageController extends Controller
{
    public $ndata = [];

    public function index()
    {
        $languages = Language::all();
        return view('adtrpanel.language.index', compact('languages'));
    }

    public function languageForm($id = null)
    {
        if ($id != null) {
            $language = Language::find($id);
        }
        return view('adtrpanel.language.languageForm', compact('language'));
    }

    public function add($id = null)
    {

        if (request()->filled('language_details') && request()->filled('language_short_name')) {
            $dataArray = array();
            if (request()->hasFile('language_image')) {
                $img = Image::make(request()->file('language_image'))->fit(22,15);
                $url = '/uploads/site/' . request('language_short_name') . '_flag.png';
                $img->save(public_path($url));
                $dataArray['language_image'] = $url;
            }

            $datas = request()->only('language_details', 'language_short_name');

            $dataArray['language_details'] = request('language_details');
            $dataArray['language_short_name'] = request('language_short_name');


            if ($id != null) {
                $saveLanguage = Language::find($id)->update($dataArray);
            } else {
                $saveLanguage = Language::insert($dataArray);
            }

            if ($saveLanguage) {
                $ndata = ['message_variable' => 'success', 'message' => 'Dil Eklendi.'];
            } else {
                $ndata = ['message_variable' => 'warning', 'message' => 'Dil Eklenemedi.'];
            }

            return redirect()->route('adtrpanel.languages')->with($ndata);

        } else {
            return redirect()->back();
        }
    }

    public function setDefault(int $id)
    {

        if (!empty($id)) {
            $notDefault = Language::where('language_id', '!=', $id)->update([
                'language_default' => 0
            ]);
            $setDefault = Language::where('language_id', $id)->update([
                'language_default' => 1
            ]);

            return redirect()->route('adtrpanel.languages');
        }
    }

    public function delete($id)
    {

        if (!empty($id) && is_numeric($id)) {

            $deleteLanguage = Language::where('language_id', $id)->delete();

            if ($deleteLanguage) {
                $ndata = ['message_variable' => 'success', 'message' => 'Dil Silindi'];
            } else {
                $ndata = ['message_variable' => 'warning', 'message' => 'Dil Silinemedi'];
            }

            return redirect()->route('adtrpanel.languages')->with($ndata);

        } else {

            return redirect()->route('adtrpanel.languages');

        }

    }

}
