<?php

namespace App\Http\Controllers\Adtrpanel;

use App\Models\User;
use Illuminate\Http\Request;
use App\Models\Contact;
use App\Http\Controllers\Controller;

class ContactController extends Controller
{
    public function index()
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Contact', 'read'));
        $contacts = Contact::orderByDesc('created_at')->paginate(20);
        return view('adtrpanel.contact', compact('contacts'));
    }
    public function delete($contact_id)
    {
        $userPermission = auth()->guard('adtrpanel')->user();
        User::where('id', $userPermission->id)->first()->authorizeRoles(rolesArray('Contact', 'delete'));
        Contact::where('contact_id',$contact_id)->delete();
        return redirect()->route('adtrpanel.contact');
    }
}
